from _typeshed import Incomplete
from typing import ClassVar

from pony.orm.dbapiprovider import DBAPIProvider

class DBSchema:
    dialect: ClassVar[str | None]
    inline_fk_syntax: ClassVar[bool]
    named_foreign_keys: ClassVar[bool]
    table_class: ClassVar[type[Table]]
    column_class: ClassVar[type[Column]]
    index_class: ClassVar[type[DBIndex]]
    fk_class: ClassVar[type[ForeignKey]]
    provider: DBAPIProvider
    tables: dict[Incomplete, Incomplete]
    constraints: dict[Incomplete, Incomplete]
    indent: str
    command_separator: str
    uppercase: bool
    names: dict[Incomplete, Incomplete]
    def __init__(schema, provider: DBAPIProvider, uppercase: bool = True) -> None: ...
    def column_list(schema, columns): ...
    def case(schema, s: str) -> str: ...
    def add_table(schema, table_name, entity=None): ...
    def order_tables_to_create(schema): ...
    def generate_create_script(schema): ...
    def create_tables(schema, provider: DBAPIProvider, connection) -> None: ...
    def check_tables(schema, provider: DBAPIProvider, connection) -> None: ...

class DBObject:
    def create(table, provider, connection) -> None: ...

class Table(DBObject):
    typename: ClassVar[str]
    def __init__(table, name, schema, entity=None) -> None: ...
    def add_entity(table, entity) -> None: ...
    def exists(table, provider: DBAPIProvider, connection, case_sensitive: bool = True): ...
    def get_create_command(table): ...
    def format_option(table, name, value): ...
    def get_objects_to_create(table, created_tables: set[Table] | None = None) -> list[Table]: ...
    def add_column(table, column_name, sql_type, converter, is_not_null: bool | None = None, sql_default=None): ...
    def add_index(table, index_name, columns, is_pk: bool = False, is_unique=None, m2m: bool = False): ...
    def add_foreign_key(
        table,
        fk_name,
        child_columns,
        parent_table,
        parent_columns,
        index_name=None,
        on_delete: bool = False,
        interleave: bool = False,
    ): ...

class Column:
    auto_template: ClassVar[str]
    def __init__(column, name, table, sql_type, converter, is_not_null: bool | None = None, sql_default=None) -> None: ...
    def get_sql(column) -> str: ...

class Constraint(DBObject):
    schema: DBSchema
    name: str | None
    def __init__(constraint, name: str | None, schema: DBSchema) -> None: ...

class DBIndex(Constraint):
    typename: ClassVar[str]
    def __init__(index, name: str | None, table, columns, is_pk: bool = False, is_unique=None) -> None: ...
    def exists(index, provider, connection, case_sensitive: bool = True): ...
    def get_sql(index) -> str: ...
    def get_create_command(index): ...

class ForeignKey(Constraint):
    typename: ClassVar[str]
    def __init__(
        foreign_key,
        name,
        child_table,
        child_columns,
        parent_table,
        parent_columns,
        index_name,
        on_delete,
        interleave: bool = False,
    ) -> None: ...
    def exists(foreign_key, provider, connection, case_sensitive: bool = True): ...
    def get_sql(foreign_key) -> str: ...
    def get_create_command(foreign_key): ...
