import datetime
from typing import Final, Literal

from ..core import WesternCalendar

class Netherlands(WesternCalendar):
    include_carnival: bool
    def __init__(self, include_carnival: bool = False) -> None: ...
    def get_king_queen_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_carnival_days(self, year: int) -> list[tuple[datetime.date, str]]: ...

FALL_HOLIDAYS_EARLY_REGIONS: Final[dict[int, list[str]]]
SPRING_HOLIDAYS_EARLY_REGIONS: Final[dict[int, list[str]]]
SUMMER_HOLIDAYS_EARLY_REGIONS: Final[dict[int, list[str]]]
SUMMER_HOLIDAYS_LATE_REGIONS: Final[dict[int, list[str]]]

class NetherlandsWithSchoolHolidays(Netherlands):
    region: Literal["north", "middle", "south"]
    carnival_instead_of_spring: bool
    def __init__(
        self,
        region: Literal["north", "middle", "south"],
        carnival_instead_of_spring: bool = False,
        *,
        include_carnival: bool = ...,
    ) -> None: ...
    def get_fall_holidays(self, year: int) -> list[tuple[datetime.date, str]]: ...
    def get_christmas_holidays(self, year: int) -> list[tuple[datetime.date, str]]: ...
    def get_spring_holidays(self, year: int) -> list[tuple[datetime.date, str]]: ...
    def get_carnival_holidays(self, year: int) -> list[tuple[datetime.date, str]]: ...
    def get_may_holidays(self, year: int) -> list[tuple[datetime.date, str]]: ...
    def get_summer_holidays(self, year: int) -> list[tuple[datetime.date, str]]: ...
