/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.IndexSchema;

public class ConfigSet {
    private final String name;
    private final SolrConfig solrConfig;
    private volatile IndexSchema schema;
    private final SchemaSupplier schemaSupplier;
    private final NamedList<?> properties;
    private final boolean trusted;

    public ConfigSet(String name, SolrConfig solrConfig, SchemaSupplier indexSchemaSupplier, NamedList<?> properties, boolean trusted) {
        this.name = name;
        this.solrConfig = solrConfig;
        this.schemaSupplier = indexSchemaSupplier;
        this.schema = this.schemaSupplier.get(true);
        this.properties = properties;
        this.trusted = trusted;
    }

    public String getName() {
        return this.name;
    }

    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public IndexSchema getIndexSchema(boolean forceFetch) {
        if (forceFetch) {
            this.schema = this.schemaSupplier.get(true);
        }
        return this.schema;
    }

    public IndexSchema getIndexSchema() {
        return this.schema;
    }

    public NamedList<?> getProperties() {
        return this.properties;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    static interface SchemaSupplier {
        public IndexSchema get(boolean var1);
    }
}

