/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import org.apache.solr.client.api.endpoint.CollectionStatusApi;
import org.apache.solr.client.api.model.CollectionStatusResponse;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.ColStatus;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJacksonMapper;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CollectionStatus
extends AdminAPIBase
implements CollectionStatusApi {
    @Inject
    public CollectionStatus(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public CollectionStatusResponse getCollectionStatus(String collectionName, Boolean coreInfo, Boolean segments, Boolean fieldInfo, Boolean rawSize, Boolean rawSizeSummary, Boolean rawSizeDetails, Float rawSizeSamplingPercent, Boolean sizeInfo) throws Exception {
        CollectionStatus.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("collection", new String[]{collectionName});
        params.setNonNull("coreInfo", (Object)coreInfo);
        params.setNonNull("segments", (Object)segments);
        params.setNonNull("fieldInfo", (Object)fieldInfo);
        params.setNonNull("rawSize", (Object)rawSize);
        params.setNonNull("rawSizeSummary", (Object)rawSizeSummary);
        params.setNonNull("rawSizeDetails", (Object)rawSizeDetails);
        params.setNonNull("rawSizeSamplingPercent", (Object)rawSizeSamplingPercent);
        params.setNonNull("sizeInfo", (Object)sizeInfo);
        NamedList nlResponse = new NamedList();
        CollectionStatus.populateColStatusData(this.coreContainer, new ZkNodeProps((MapWriter)params), (NamedList<Object>)nlResponse);
        CollectionStatusResponse colStatusResponse = (CollectionStatusResponse)SolrJacksonMapper.getObjectMapper().convertValue(nlResponse.get(collectionName), CollectionStatusResponse.class);
        colStatusResponse.name = collectionName;
        return colStatusResponse;
    }

    public static void populateColStatusData(CoreContainer coreContainer, ZkNodeProps params, NamedList<Object> colStatusSink) {
        ColStatus colStatusAssembler = new ColStatus(coreContainer.getDefaultHttpSolrClient(), coreContainer.getZkController().getClusterState(), params);
        colStatusAssembler.getColStatus(colStatusSink);
    }
}

