/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmMetric;

public class SolrJvmOsMetric
extends SolrJvmMetric {
    public static final String JVM_OS_THREADS = "solr_metrics_jvm_threads";
    public static final String JVM_OS = "solr_metrics_os";

    public SolrJvmOsMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        if (parsedMetric[0].equals("threads")) {
            this.labels.put("item", parsedMetric[1]);
        } else {
            this.labels.put("item", parsedMetric[parsedMetric.length - 1]);
        }
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        if (this.metricName.startsWith("threads.")) {
            formatter.exportGauge(JVM_OS_THREADS, (Gauge)this.dropwizardMetric, this.getLabels());
        } else {
            formatter.exportGauge(JVM_OS, (Gauge)this.dropwizardMetric, this.getLabels());
        }
    }
}

