/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.ResultContext;
import org.apache.solr.search.DocIterationInfo;

public abstract class DocTransformer {
    protected ResultContext context;

    public abstract String getName();

    public void setContext(ResultContext context) {
        this.context = context;
    }

    public Collection<String> getRawFields() {
        return Collections.emptySet();
    }

    public boolean needsSolrIndexSearcher() {
        return false;
    }

    @Deprecated(forRemoval=true, since="9.9.0")
    public void transform(SolrDocument doc, int docid, float score) throws IOException {
        this.transform(doc, docid);
    }

    public void transform(SolrDocument doc, int docid, DocIterationInfo docInfo) throws IOException {
        this.transform(doc, docid, docInfo.score());
    }

    @Deprecated(since="9.9.0")
    public abstract void transform(SolrDocument var1, int var2) throws IOException;

    public String[] getExtraRequestFields() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static final class NoopFieldTransformer
    extends DocTransformer {
        final String field;

        public NoopFieldTransformer() {
            this.field = null;
        }

        public NoopFieldTransformer(String field) {
            this.field = field;
        }

        @Override
        public String getName() {
            return "noop";
        }

        @Override
        public String[] getExtraRequestFields() {
            String[] stringArray;
            if (this.field == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.field;
            }
            return stringArray;
        }

        @Override
        public void transform(SolrDocument doc, int docid) {
        }
    }
}

