/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.schema.CurrencyFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieLongField;

@Deprecated
public class CurrencyField
extends CurrencyFieldType
implements SchemaAware,
ResourceLoaderAware {
    protected static final String FIELD_SUFFIX_AMOUNT_RAW = "_amount_raw";
    protected static final String FIELD_SUFFIX_CURRENCY = "_currency";
    protected static final String FIELD_TYPE_AMOUNT_RAW = "amount_raw_type_long";
    protected static final String FIELD_TYPE_CURRENCY = "currency_type_string";
    protected static final String PARAM_PRECISION_STEP = "precisionStep";
    protected static final String DEFAULT_PRECISION_STEP = "0";

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        ArrayList<String> unknownParams = new ArrayList<String>();
        this.fieldSuffixAmountRaw = args.get("amountLongSuffix");
        if (this.fieldSuffixAmountRaw != null) {
            unknownParams.add("amountLongSuffix");
        }
        this.fieldSuffixCurrency = args.get("codeStrSuffix");
        if (this.fieldSuffixCurrency != null) {
            unknownParams.add("codeStrSuffix");
        }
        if (!unknownParams.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown parameter(s): " + String.valueOf(unknownParams));
        }
        String precisionStepString = args.get(PARAM_PRECISION_STEP);
        if (precisionStepString == null) {
            precisionStepString = DEFAULT_PRECISION_STEP;
        } else {
            args.remove(PARAM_PRECISION_STEP);
        }
        this.fieldTypeAmountRaw = new TrieLongField();
        this.fieldTypeAmountRaw.setTypeName(FIELD_TYPE_AMOUNT_RAW);
        HashMap map = CollectionUtil.newHashMap((int)1);
        map.put(PARAM_PRECISION_STEP, precisionStepString);
        this.fieldTypeAmountRaw.init(schema, map);
        this.fieldSuffixAmountRaw = FIELD_SUFFIX_AMOUNT_RAW;
        this.fieldTypeCurrency = new StrField();
        this.fieldTypeCurrency.setTypeName(FIELD_TYPE_CURRENCY);
        this.fieldTypeCurrency.init(schema, Collections.emptyMap());
        this.fieldSuffixCurrency = FIELD_SUFFIX_CURRENCY;
        super.init(schema, args);
    }

    private void createDynamicCurrencyField(String suffix, FieldType type) {
        String name = "*___" + suffix;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("indexed", "true");
        props.put("stored", "false");
        props.put("multiValued", "false");
        props.put("omitNorms", "true");
        props.put("uninvertible", "true");
        int p = SchemaField.calcProps(name, type, props);
        this.schema.registerDynamicFields(SchemaField.create(name, type, p, null));
    }

    @Override
    public void inform(IndexSchema schema) {
        this.createDynamicCurrencyField(FIELD_SUFFIX_CURRENCY, this.fieldTypeCurrency);
        this.createDynamicCurrencyField(FIELD_SUFFIX_AMOUNT_RAW, this.fieldTypeAmountRaw);
        super.inform(schema);
    }
}

