/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.mahout.matrix.impl;

import org.carrot2.math.mahout.matrix.DoubleMatrix1D;
import org.carrot2.math.mahout.matrix.DoubleMatrix2D;
import org.carrot2.math.mahout.matrix.impl.DelegateDoubleMatrix1D;

class WrapperDoubleMatrix2D
extends DoubleMatrix2D {
    private final DoubleMatrix2D content;

    WrapperDoubleMatrix2D(DoubleMatrix2D newContent) {
        if (newContent != null) {
            this.setUp(newContent.rows(), newContent.columns());
        }
        this.content = newContent;
    }

    @Override
    protected DoubleMatrix2D getContent() {
        return this.content;
    }

    @Override
    public double getQuick(int row, int column) {
        return this.content.getQuick(row, column);
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return this.content.like1D(size);
    }

    @Override
    protected DoubleMatrix1D like1D(int size, int offset, int stride) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.content.setQuick(row, column, value);
    }

    @Override
    public DoubleMatrix1D viewColumn(int column) {
        return this.viewDice().viewRow(column);
    }

    @Override
    public DoubleMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        return new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int row, int column) {
                return WrapperDoubleMatrix2D.this.content.get(row, this.columns - 1 - column);
            }

            @Override
            public void setQuick(int row, int column, double value) {
                WrapperDoubleMatrix2D.this.content.set(row, this.columns - 1 - column, value);
            }
        };
    }

    @Override
    public DoubleMatrix2D viewDice() {
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int row, int column) {
                return WrapperDoubleMatrix2D.this.content.get(column, row);
            }

            @Override
            public void setQuick(int row, int column, double value) {
                WrapperDoubleMatrix2D.this.content.set(column, row, value);
            }
        };
        view.rows = this.columns;
        view.columns = this.rows;
        return view;
    }

    @Override
    public DoubleMatrix2D viewPart(final int row, final int column, int height, int width) {
        this.checkBox(row, column, height, width);
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int i, int j) {
                return WrapperDoubleMatrix2D.this.content.get(row + i, column + j);
            }

            @Override
            public void setQuick(int i, int j, double value) {
                WrapperDoubleMatrix2D.this.content.set(row + i, column + j, value);
            }
        };
        view.rows = height;
        view.columns = width;
        return view;
    }

    @Override
    public DoubleMatrix1D viewRow(int row) {
        this.checkRow(row);
        return new DelegateDoubleMatrix1D(this, row);
    }

    @Override
    public DoubleMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        return new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int row, int column) {
                return WrapperDoubleMatrix2D.this.content.get(this.rows - 1 - row, column);
            }

            @Override
            public void setQuick(int row, int column, double value) {
                WrapperDoubleMatrix2D.this.content.set(this.rows - 1 - row, column, value);
            }
        };
    }

    @Override
    public DoubleMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int i, int j) {
                return WrapperDoubleMatrix2D.this.content.get(rix[i], cix[j]);
            }

            @Override
            public void setQuick(int i, int j, double value) {
                WrapperDoubleMatrix2D.this.content.set(rix[i], cix[j], value);
            }
        };
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        return view;
    }

    @Override
    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new UnsupportedOperationException();
    }
}

