/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collector;
import org.apache.sis.image.AnnotatedImage;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;

final class StatisticsCalculator
extends AnnotatedImage {
    private final DoubleUnaryOperator[] sampleFilters;

    StatisticsCalculator(RenderedImage renderedImage, Shape shape, DoubleUnaryOperator[] doubleUnaryOperatorArray, boolean bl, boolean bl2) {
        super(renderedImage, shape, bl, bl2);
        if (doubleUnaryOperatorArray != null && ArraysExt.allEquals(doubleUnaryOperatorArray = Arrays.copyOf(doubleUnaryOperatorArray, ImageUtilities.getNumBands(renderedImage)), null)) {
            doubleUnaryOperatorArray = null;
        }
        this.sampleFilters = doubleUnaryOperatorArray;
    }

    @Override
    final Object[] getExtraParameter() {
        return this.sampleFilters;
    }

    @Override
    protected String getComputedPropertyName() {
        return "org.apache.sis.Statistics";
    }

    private static Statistics[] createAccumulator(int n) {
        Statistics[] statisticsArray = new Statistics[n];
        for (int i = 0; i < n; ++i) {
            statisticsArray[i] = new Statistics((CharSequence)Vocabulary.formatInternational((short)15, (Object)i));
        }
        return statisticsArray;
    }

    private final DoubleConsumer[] filtered(Statistics[] statisticsArray) {
        if (this.sampleFilters == null) {
            return statisticsArray;
        }
        DoubleConsumer[] doubleConsumerArray = new DoubleConsumer[statisticsArray.length];
        for (int i = 0; i < doubleConsumerArray.length; ++i) {
            Statistics statistics = statisticsArray[i];
            DoubleUnaryOperator doubleUnaryOperator = this.sampleFilters[i];
            doubleConsumerArray[i] = doubleUnaryOperator == null ? statistics : d -> statistics.accept(doubleUnaryOperator.applyAsDouble(d));
        }
        return doubleConsumerArray;
    }

    private void compute(DoubleConsumer[] doubleConsumerArray, PixelIterator pixelIterator) {
        double[] dArray = null;
        while (pixelIterator.next()) {
            if (this.areaOfInterest != null && !this.areaOfInterest.contains(pixelIterator.x, pixelIterator.y)) continue;
            dArray = pixelIterator.getPixel(dArray);
            for (int i = 0; i < doubleConsumerArray.length; ++i) {
                doubleConsumerArray[i].accept(dArray[i]);
            }
        }
    }

    @Override
    protected Object computeSequentially() {
        PixelIterator pixelIterator = new PixelIterator.Builder().setRegionOfInterest(this.boundsOfInterest).create(this.source);
        Statistics[] statisticsArray = StatisticsCalculator.createAccumulator(pixelIterator.getNumBands());
        this.compute(this.filtered(statisticsArray), pixelIterator);
        return statisticsArray;
    }

    @Override
    protected Object cloneProperty(String string, Object object) {
        Statistics[] statisticsArray = (Statistics[])((Statistics[])object).clone();
        for (int i = 0; i < statisticsArray.length; ++i) {
            statisticsArray[i] = statisticsArray[i].clone();
        }
        return statisticsArray;
    }

    protected Collector<Raster, Statistics[], Statistics[]> collector() {
        return Collector.of(this::createAccumulator, this::compute, StatisticsCalculator::combine, new Collector.Characteristics[0]);
    }

    private Statistics[] createAccumulator() {
        return StatisticsCalculator.createAccumulator(ImageUtilities.getNumBands(this.source));
    }

    private static Statistics[] combine(Statistics[] statisticsArray, Statistics[] statisticsArray2) {
        for (int i = 0; i < statisticsArray2.length; ++i) {
            statisticsArray[i].combine(statisticsArray2[i]);
        }
        return statisticsArray;
    }

    private void compute(Statistics[] statisticsArray, Raster raster) {
        this.compute(this.filtered(statisticsArray), new PixelIterator.Builder().setRegionOfInterest(this.boundsOfInterest).create(raster));
    }

    static DoubleUnaryOperator filterNodataValues(Number[] numberArray) {
        double d3;
        double[] dArray = new double[numberArray.length];
        int n = 0;
        Number[] numberArray2 = numberArray;
        int n2 = numberArray2.length;
        for (int i = 0; i < n2; ++i) {
            Number number = numberArray2[i];
            if (number == null) continue;
            dArray[n++] = number.doubleValue();
        }
        Arrays.sort(dArray, 0, n);
        int n3 = n;
        n = 0;
        for (n2 = 0; n2 < n3 && !Double.isNaN(d3 = dArray[n2]); ++n2) {
            if (n != 0) {
                if (dArray[n - 1] == d3) continue;
                dArray[n] = d3;
            }
            ++n;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                double d4 = dArray[0];
                return d2 -> d4 != d2 ? d2 : Double.NaN;
            }
        }
        double[] dArray2 = ArraysExt.resize(dArray, n);
        return d -> Arrays.binarySearch(dArray2, d) < 0 ? d : Double.NaN;
    }
}

