/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.routing;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.routing.NoOpReplicaListTransformer;
import org.apache.solr.client.solrj.routing.PreferenceRule;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.common.cloud.NodesSysProps;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.SolrParams;

public class NodePreferenceRulesComparator {
    private final NodesSysProps sysProps;
    private final String nodeName;
    private final List<PreferenceRule> sortRules;
    private final List<PreferenceRule> preferenceRules;
    private final String baseUrl;
    private final String hostName;
    private final ReplicaListTransformer baseReplicaListTransformer;
    private static final ReplicaListTransformer NOOP_RLT = NoOpReplicaListTransformer.INSTANCE;
    private static final ReplicaListTransformerFactory NOOP_RLTF = (configSpec, requestParams, fallback) -> NOOP_RLT;

    public NodePreferenceRulesComparator(List<PreferenceRule> preferenceRules, SolrParams requestParams, ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory) {
        this(preferenceRules, requestParams, null, null, null, null, defaultRltFactory, stableRltFactory);
    }

    public NodePreferenceRulesComparator(List<PreferenceRule> preferenceRules, SolrParams requestParams, String nodeName, String baseUrl, String hostName, NodesSysProps sysProps, ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory) {
        this.sysProps = sysProps;
        this.preferenceRules = preferenceRules;
        this.nodeName = nodeName;
        this.baseUrl = baseUrl;
        this.hostName = hostName;
        int maxIdx = preferenceRules.size() - 1;
        PreferenceRule lastRule = preferenceRules.get(maxIdx);
        if (!"replica.base".equals(lastRule.name)) {
            this.sortRules = preferenceRules;
            this.baseReplicaListTransformer = defaultRltFactory.getInstance(null, requestParams, RequestReplicaListTransformerGenerator.RANDOM_RLTF);
        } else {
            this.sortRules = maxIdx == 0 ? null : preferenceRules.subList(0, maxIdx);
            String[] parts = lastRule.value.split(":", 2);
            switch (parts[0]) {
                case "random": {
                    this.baseReplicaListTransformer = RequestReplicaListTransformerGenerator.RANDOM_RLTF.getInstance(parts.length == 1 ? null : parts[1], requestParams, null);
                    break;
                }
                case "stable": {
                    this.baseReplicaListTransformer = stableRltFactory.getInstance(parts.length == 1 ? null : parts[1], requestParams, RequestReplicaListTransformerGenerator.RANDOM_RLTF);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid base replica order spec");
                }
            }
        }
    }

    NodePreferenceRulesComparator(List<PreferenceRule> preferenceRules, SolrParams requestParams) {
        this(preferenceRules, requestParams, NOOP_RLTF, null);
    }

    NodePreferenceRulesComparator(List<PreferenceRule> preferenceRules, SolrParams requestParams, String nodeName, String baseUrl, String hostName) {
        this(preferenceRules, requestParams, nodeName, baseUrl, hostName, null, NOOP_RLTF, null);
    }

    public ReplicaListTransformer getBaseReplicaListTransformer() {
        return this.baseReplicaListTransformer;
    }

    public <T> Comparator<T> getComparator(T example) {
        if (example instanceof Replica) {
            return this.getReplicaComparator();
        }
        if (example instanceof String) {
            return this.getUrlComparator();
        }
        return null;
    }

    public Comparator<Replica> getReplicaComparator() {
        Comparator<Replica> comparator = null;
        if (this.sortRules != null) {
            for (PreferenceRule preferenceRule : this.sortRules) {
                Comparator<Replica> nextComparator = this.getPreferenceReplicaComparator(preferenceRule);
                if (nextComparator == null) continue;
                if (comparator != null) {
                    comparator = comparator.thenComparing(nextComparator);
                    continue;
                }
                comparator = nextComparator;
            }
        }
        return comparator;
    }

    public Comparator<String> getUrlComparator() {
        Comparator<String> comparator = null;
        if (this.sortRules != null) {
            for (PreferenceRule preferenceRule : this.sortRules) {
                Comparator<String> nextComparator = this.getPreferenceUrlComparator(preferenceRule);
                if (nextComparator == null) continue;
                if (comparator != null) {
                    comparator = comparator.thenComparing(nextComparator);
                    continue;
                }
                comparator = nextComparator;
            }
        }
        return comparator;
    }

    private Comparator<Replica> getPreferenceReplicaComparator(PreferenceRule preferenceRule) {
        Comparator<Replica> comparator;
        block7 : switch (preferenceRule.name) {
            case "replica.type": {
                comparator = Comparator.comparing(r -> r.getType().toString().equalsIgnoreCase(preferenceRule.value));
                break;
            }
            case "replica.location": {
                switch (preferenceRule.value) {
                    case "local": {
                        if (this.baseUrl == null) {
                            return null;
                        }
                        comparator = Comparator.comparing(r -> r.getBaseUrl().equals(this.baseUrl));
                        break block7;
                    }
                    case "host": {
                        if (this.hostName == null) {
                            return null;
                        }
                        String hostNameWithColon = this.hostName + ":";
                        comparator = Comparator.comparing(r -> r.getNodeName().startsWith(hostNameWithColon));
                        break block7;
                    }
                }
                comparator = Comparator.comparing(r -> r.getCoreUrl().startsWith(preferenceRule.value));
                break;
            }
            case "replica.leader": {
                boolean preferredIsLeader = Boolean.parseBoolean(preferenceRule.value);
                comparator = Comparator.comparing(r -> r.isLeader() == preferredIsLeader);
                break;
            }
            case "node.sysprop": {
                if (this.sysProps == null) {
                    return null;
                }
                List<String> tags = Collections.singletonList(preferenceRule.value);
                Map<String, Object> currentNodeMetric = this.sysProps.getSysProps(this.nodeName, tags);
                comparator = Comparator.comparing(r -> currentNodeMetric.equals(this.sysProps.getSysProps(r.getNodeName(), tags)));
                break;
            }
            case "replica.base": {
                throw new IllegalArgumentException("only one base replica order may be specified in shards.preference, and it must be specified last");
            }
            default: {
                throw new IllegalArgumentException("Invalid shards.preference type: " + preferenceRule.name);
            }
        }
        return comparator != null ? comparator.reversed() : null;
    }

    private Comparator<String> getPreferenceUrlComparator(PreferenceRule preferenceRule) {
        Comparator<String> comparator;
        block7 : switch (preferenceRule.name) {
            case "replica.type": 
            case "replica.leader": 
            case "node.sysprop": {
                return null;
            }
            case "replica.location": {
                switch (preferenceRule.value) {
                    case "local": {
                        if (this.baseUrl == null) {
                            return null;
                        }
                        comparator = Comparator.comparing(url -> url.startsWith(this.baseUrl));
                        break block7;
                    }
                    case "host": {
                        if (this.hostName == null) {
                            return null;
                        }
                        String scheme = this.baseUrl.startsWith("https") ? "https" : "http";
                        String baseUrlHostPrefix = scheme + "://" + this.hostName + ":";
                        comparator = Comparator.comparing(url -> url.startsWith(baseUrlHostPrefix));
                        break block7;
                    }
                }
                comparator = Comparator.comparing(url -> url.startsWith(preferenceRule.value));
                break;
            }
            case "replica.base": {
                throw new IllegalArgumentException("only one base replica order may be specified in shards.preference, and it must be specified last");
            }
            default: {
                throw new IllegalArgumentException("Invalid shards.preference type: " + preferenceRule.name);
            }
        }
        return comparator != null ? comparator.reversed() : null;
    }

    public List<PreferenceRule> getPreferenceRules() {
        return this.preferenceRules;
    }
}

