/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.MapProjectionDescriptor;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;

final class MapProjectionParameters
extends DefaultParameterValueGroup {
    private static final long serialVersionUID = -6801091012335717139L;
    private transient ParameterValue<Double> earthRadius;
    private transient InverseFlattening inverseFlattening;
    private transient ParameterValue<double[]> standardParallel;
    private transient ParameterValue<Boolean> isIvfDefinitive;

    MapProjectionParameters(MapProjectionDescriptor mapProjectionDescriptor) {
        super(mapProjectionDescriptor);
    }

    @Override
    boolean isKnownImplementation() {
        return true;
    }

    @Override
    ParameterValue<?> parameterIfExist(String string) throws ParameterNotFoundException {
        if (MapProjectionDescriptor.isHeuristicMatchForName(string, "earth_radius")) {
            if (this.earthRadius == null) {
                this.earthRadius = new EarthRadius(this.parameter("semi_major"), this.parameter("semi_minor"));
            }
            return this.earthRadius;
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(string, "inverse_flattening")) {
            return this.getInverseFlattening();
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(string, "is_ivf_definitive")) {
            if (this.isIvfDefinitive == null) {
                this.isIvfDefinitive = new IsIvfDefinitive(this.getInverseFlattening());
            }
            return this.isIvfDefinitive;
        }
        if (((MapProjectionDescriptor)this.getDescriptor()).hasStandardParallels && MapProjectionDescriptor.isHeuristicMatchForName(string, "standard_parallel")) {
            if (this.standardParallel == null) {
                this.standardParallel = new StandardParallel(this.parameter("standard_parallel_1"), this.parameter("standard_parallel_2"));
            }
            return this.standardParallel;
        }
        return super.parameterIfExist(string);
    }

    private InverseFlattening getInverseFlattening() {
        if (this.inverseFlattening == null) {
            this.inverseFlattening = new InverseFlattening(this.parameter("semi_major"), this.parameter("semi_minor"));
        }
        return this.inverseFlattening;
    }

    @Override
    public MapProjectionParameters clone() {
        MapProjectionParameters mapProjectionParameters = (MapProjectionParameters)super.clone();
        mapProjectionParameters.earthRadius = null;
        mapProjectionParameters.inverseFlattening = null;
        mapProjectionParameters.standardParallel = null;
        mapProjectionParameters.isIvfDefinitive = null;
        return mapProjectionParameters;
    }

    static final class EarthRadius
    extends DefaultParameterValue<Double> {
        private static final long serialVersionUID = 5848432458976184182L;
        static final ParameterDescriptor<Double> DESCRIPTOR = new DefaultParameterDescriptor<Object>(InverseFlattening.toMap("earth_radius"), 0, 1, Double.class, MeasurementRange.createGreaterThan(0.0, Units.METRE), null, null);
        private final ParameterValue<?> semiMajor;
        private final ParameterValue<?> semiMinor;

        EarthRadius(ParameterValue<?> parameterValue, ParameterValue<?> parameterValue2) {
            super(DESCRIPTOR);
            this.semiMajor = parameterValue;
            this.semiMinor = parameterValue2;
        }

        @Override
        protected void setValue(Object object, Unit<?> unit) {
            super.setValue(object, unit);
            double d = (Double)object;
            this.semiMajor.setValue(d, unit);
            this.semiMinor.setValue(d, unit);
        }

        @Override
        public double doubleValue() {
            double d = this.semiMajor.doubleValue();
            if (this.semiMinor.getValue() != null) {
                d = Formulas.getAuthalicRadius(d, this.semiMinor.doubleValue(this.semiMajor.getUnit()));
            }
            return d;
        }

        @Override
        public Unit<?> getUnit() {
            return this.semiMajor.getUnit();
        }

        @Override
        public Double getValue() {
            return this.doubleValue();
        }
    }

    static final class InverseFlattening
    extends DefaultParameterValue<Double> {
        private static final long serialVersionUID = 4490056024453509851L;
        static final ParameterDescriptor<Double> DESCRIPTOR = new DefaultParameterDescriptor<Object>(InverseFlattening.toMap("inverse_flattening"), 0, 1, Double.class, MeasurementRange.createGreaterThan(0.0, Units.UNITY), null, null);
        private final ParameterValue<?> semiMajor;
        private final ParameterValue<?> semiMinor;
        private double inverseFlattening;
        private double a;
        private double b;

        static Map<String, ?> toMap(String string) {
            return Collections.singletonMap("name", new NamedIdentifier(Citations.NETCDF, string));
        }

        InverseFlattening(ParameterValue<?> parameterValue, ParameterValue<?> parameterValue2) {
            super(DESCRIPTOR);
            this.semiMajor = parameterValue;
            this.semiMinor = parameterValue2;
            this.invalidate();
        }

        void invalidate() {
            this.b = Double.NaN;
            this.a = Double.NaN;
        }

        boolean isIvfDefinitive() {
            Number number;
            Number number2;
            if (this.inverseFlattening > 0.0 && (number2 = (Number)this.semiMajor.getValue()) != null && number2.doubleValue() == this.a && (number = (Number)this.semiMinor.getValue()) != null && number.doubleValue() == this.b) {
                return Objects.equals(this.semiMajor.getUnit(), this.semiMinor.getUnit());
            }
            return false;
        }

        @Override
        protected void setValue(Object object, Unit<?> unit) {
            super.setValue(object, unit);
            double d = (Double)object;
            Number number = (Number)this.semiMajor.getValue();
            if (number != null) {
                this.a = number.doubleValue();
                this.b = Formulas.getSemiMinor(this.a, d);
                this.semiMinor.setValue(this.b, this.semiMajor.getUnit());
            } else {
                this.invalidate();
            }
            this.inverseFlattening = d;
        }

        @Override
        public double doubleValue() {
            double d = this.semiMajor.doubleValue();
            double d2 = this.semiMinor.doubleValue(this.semiMajor.getUnit());
            if (d == this.a && d2 == this.b && this.inverseFlattening > 0.0) {
                return this.inverseFlattening;
            }
            return Formulas.getInverseFlattening(d, d2);
        }

        @Override
        public Double getValue() {
            return this.doubleValue();
        }
    }

    static final class IsIvfDefinitive
    extends DefaultParameterValue<Boolean> {
        private static final long serialVersionUID = 5988883252321358629L;
        static final ParameterDescriptor<Boolean> DESCRIPTOR = new DefaultParameterDescriptor<Boolean>(InverseFlattening.toMap("is_ivf_definitive"), 0, 1, Boolean.class, null, null, Boolean.FALSE);
        private final InverseFlattening inverseFlattening;

        IsIvfDefinitive(InverseFlattening inverseFlattening) {
            super(DESCRIPTOR);
            this.inverseFlattening = inverseFlattening;
        }

        @Override
        protected void setValue(Object object, Unit<?> unit) {
            super.setValue(object, unit);
            if (!((Boolean)object).booleanValue()) {
                this.inverseFlattening.invalidate();
            }
        }

        @Override
        public boolean booleanValue() {
            return this.inverseFlattening.isIvfDefinitive();
        }

        @Override
        public Boolean getValue() {
            return this.booleanValue();
        }
    }

    static final class StandardParallel
    extends DefaultParameterValue<double[]> {
        private static final long serialVersionUID = -1379566730374843040L;
        static final ParameterDescriptor<double[]> DESCRIPTOR = new DefaultParameterDescriptor<Object>(InverseFlattening.toMap("standard_parallel"), 0, 1, double[].class, null, null, null);
        private final ParameterValue<?> standardParallel1;
        private final ParameterValue<?> standardParallel2;

        StandardParallel(ParameterValue<?> parameterValue, ParameterValue<?> parameterValue2) {
            super(DESCRIPTOR);
            this.standardParallel1 = parameterValue;
            this.standardParallel2 = parameterValue2;
        }

        @Override
        protected void setValue(Object object, Unit<?> unit) {
            super.setValue(object, unit);
            double d = Double.NaN;
            double d2 = Double.NaN;
            if (object != null) {
                double[] dArray = (double[])object;
                switch (dArray.length) {
                    default: {
                        throw new IllegalArgumentException(Errors.format((short)133, 2, dArray.length));
                    }
                    case 2: {
                        d2 = dArray[1];
                    }
                    case 1: {
                        d = dArray[0];
                    }
                    case 0: 
                }
            }
            this.standardParallel1.setValue(d, unit);
            this.standardParallel2.setValue(d2, unit);
        }

        @Override
        public double[] getValue() {
            Number number = (Number)this.standardParallel1.getValue();
            Number number2 = (Number)this.standardParallel2.getValue();
            if (number2 == null) {
                if (number == null) {
                    return ArraysExt.EMPTY_DOUBLE;
                }
                return new double[]{number.doubleValue()};
            }
            return new double[]{number != null ? number.doubleValue() : Double.NaN, number2.doubleValue()};
        }
    }
}

