/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import java.util.ArrayList;
import java.util.List;

public class IanaEntry {
    private static final String MIME_TYPE_BASE_URL = "https://www.iana.org/assignments/media-types/";
    private static final String RFC_REFERENCE_BASE_URL = "https://tools.ietf.org/html/";
    private static final String MIME_TYPE_REFERENCE_BASE_URL = "https://www.iana.org/assignments/media-types/media-types.xhtm";
    private final String name;
    private final String mimeType;
    private final String mimeTypeUrl;
    private final List<String> references;
    private final List<String> referenceUrls;

    public IanaEntry(String name, String mimeType, List<String> references) {
        this.name = name;
        this.mimeType = mimeType;
        this.mimeTypeUrl = MIME_TYPE_BASE_URL + mimeType;
        this.references = references;
        this.referenceUrls = this.buildUrls(references);
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMimeTypeUrl() {
        return this.mimeTypeUrl;
    }

    public List<String> getReferences() {
        return this.references;
    }

    public List<String> getReferenceUrls() {
        return this.referenceUrls;
    }

    private List<String> buildUrls(List<String> references) {
        ArrayList<String> urls = new ArrayList<String>(references.size());
        for (String url : references) {
            if (url.toUpperCase().startsWith("RFC")) {
                url = RFC_REFERENCE_BASE_URL + url;
            } else if (!url.startsWith("http")) {
                url = "https://www.iana.org/assignments/media-types/media-types.xhtm#" + url;
            }
            urls.add(url);
        }
        return urls;
    }
}

