/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jpl7.Atom;
import org.jpl7.Query;
import org.jpl7.Term;

public class Dict
extends Term {
    protected Term tag;
    protected final Map<Atom, Term> map;

    public Dict(Term term, Map<Atom, Term> map) {
        this.tag = term;
        this.map = map;
    }

    public Dict(String string) {
        Term term = new Query(String.format("term_to_atom(_A, '%s'), _A =.. [_| X]", string)).oneSolution().get("X");
        Term[] termArray = Term.listToTermArray(term);
        this.tag = (Atom)termArray[0];
        this.map = new HashMap<Atom, Term>();
        for (int i = 1; i < termArray.length - 1; i += 2) {
            this.map.put((Atom)termArray[i + 1], termArray[i]);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Dict)) {
            return false;
        }
        Dict dict = (Dict)object;
        return this.tag.equals(dict.tag) && Objects.equals(this.map, dict.map);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.map);
    }

    public final Term getTag() {
        return this.tag;
    }

    public final Map<Atom, Term> getMap() {
        return this.map;
    }

    public final boolean hasFunctor(Term term, int n) {
        return this.tag.equals("C'dict'") && n == this.map.size() + 1;
    }

    public String toString() {
        Object object = "";
        Iterator<Atom> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Atom atom = iterator.next();
            Term term = this.map.get(atom);
            object = (String)object + String.format("%s:%s", atom.toString(), term.toString());
            if (!iterator.hasNext()) continue;
            object = (String)object + ", ";
        }
        return String.format("%s{%s}", this.tag, object);
    }

    @Override
    public final int type() {
        return 44;
    }

    @Override
    public String typeName() {
        return "Dict";
    }
}

