/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import java.io.IOException;

public class PercentUnit
extends TeXUnit {
    private int type = 0;
    public static final int LINE_WIDTH = 0;
    public static final int COLUMN_WIDTH = 1;
    public static final int TEXT_WIDTH = 2;
    public static final int COLUMN_HEIGHT = 3;
    public static final int TEXT_HEIGHT = 4;
    public static final int HSIZE = 5;
    public static final int VSIZE = 6;
    public static final int PAPER_WIDTH = 7;
    public static final int PAPER_HEIGHT = 8;
    public static final int MARGIN_WIDTH = 9;
    public static final int BOX_WIDTH = 10;

    public PercentUnit() {
        this(0);
    }

    public PercentUnit(int n) {
        this.setType(n);
    }

    @Override
    public Object clone() {
        return new PercentUnit(this.type);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object instanceof PercentUnit;
    }

    @Override
    public float toUnit(TeXParser teXParser, float f, TeXUnit teXUnit) throws TeXSyntaxException {
        float f2 = teXParser.getListener().getPageDimension(this.type) * f;
        return TeXUnit.BP.toUnit(teXParser, f2, teXUnit);
    }

    @Override
    public float fromUnit(TeXParser teXParser, float f, TeXUnit teXUnit) throws TeXSyntaxException {
        float f2 = TeXUnit.BP.fromUnit(teXParser, f, teXUnit);
        return f2 / teXParser.getListener().getPageDimension(this.type) * f;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.type = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid percent unit type " + n);
            }
        }
    }

    @Override
    public String format() {
        switch (this.type) {
            case 0: {
                return "\\linewidth ";
            }
            case 1: {
                return "\\columnwidth ";
            }
            case 2: {
                return "\\textwidth ";
            }
            case 3: {
                return "\\columnheight ";
            }
            case 4: {
                return "\\textheight ";
            }
            case 5: {
                return "\\hsize ";
            }
            case 6: {
                return "\\vsize ";
            }
            case 7: {
                return "\\paperwidth ";
            }
            case 8: {
                return "\\paperwidth ";
            }
            case 9: {
                return "\\marginparwidth ";
            }
            case 10: {
                return "\\wd ";
            }
        }
        return "";
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.getListener().createString(this.format());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        float f = teXParser.getListener().getPageDimension(this.type);
        teXParser.getListener().getWriteable().write(String.format("%fbp", Float.valueOf(f)));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

