/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.auxfile;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.AuxParser;
import java.io.IOException;

public class AuxCommand
extends ControlSequence {
    private int numArgs;
    private String labelPrefix;

    public AuxCommand(String string, int n) {
        this(string, n, null);
    }

    public AuxCommand(String string, int n, String string2) {
        super(string);
        this.numArgs = n;
        this.labelPrefix = string2;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    @Override
    public AuxCommand clone() {
        return new AuxCommand(this.getName(), this.getNumArgs(), this.labelPrefix);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        AuxParser auxParser = (AuxParser)teXParser.getListener();
        TeXObject[] teXObjectArray = new TeXObject[this.numArgs];
        for (int i = 0; i < this.numArgs; ++i) {
            teXObjectArray[i] = this.popArg(teXParser, teXObjectList);
            if (teXObjectArray[i] == null) {
                throw new NullPointerException(String.format("null arg %d for %s", i, this.getName()));
            }
            if (i != 0 || this.labelPrefix == null || this.labelPrefix.isEmpty()) continue;
            if (teXObjectArray[i] instanceof TeXObjectList) {
                ((TeXObjectList)teXObjectArray[i]).push(auxParser.createString(this.labelPrefix), true);
                continue;
            }
            TeXObjectList teXObjectList2 = auxParser.createString(this.labelPrefix);
            teXObjectList2.add(teXObjectArray[i]);
            teXObjectArray[i] = teXObjectList2;
        }
        auxParser.addAuxData(new AuxData(this.getName(), teXObjectArray));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

