/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.DocumentBlockType;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.AbstractDec;
import java.io.IOException;

public class L2HAbstract
extends AbstractDec {
    public L2HAbstract() {
        this("abstract");
    }

    public L2HAbstract(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HAbstract(this.getName());
    }

    @Override
    protected TeXObjectList getHeader(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        ControlSequence controlSequence = teXParser.getControlSequence("chapter");
        if (controlSequence == null) {
            teXObjectList2 = l2HConverter.createStack();
            teXObjectList2.add(new StartElement("h2"));
            teXObjectList2.add(new TeXCsRef("abstractname"));
            teXObjectList2.add(new EndElement("h2"));
        } else {
            teXObjectList2 = super.getHeader(teXParser, teXObjectList);
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        ControlSequence controlSequence = teXParser.getControlSequence("chapter");
        if (controlSequence == null) {
            l2HConverter.startPhantomSection("abstract", null, teXParser);
            teXParser.getListener().getWriteable().writeliteral(String.format("%n<div class=\"%s\">", this.getName()));
            l2HConverter.setCurrentBlockType(DocumentBlockType.BLOCK);
        }
        super.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        ControlSequence controlSequence = teXParser.getControlSequence("chapter");
        if (controlSequence == null) {
            l2HConverter.startPhantomSection("abstract", null, teXObjectList);
            l2HConverter.writeliteral(String.format("%n<div class=\"%s\">", this.getName()));
            l2HConverter.setCurrentBlockType(DocumentBlockType.BLOCK);
        }
        super.process(teXParser, teXObjectList);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        ControlSequence controlSequence = teXParser.getControlSequence("chapter");
        if (controlSequence == null) {
            l2HConverter.writeliteral(String.format("</div><!-- end of %s -->%n", this.getName()));
            l2HConverter.endSection();
        }
    }
}

