/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.html.VoidElement;
import java.io.IOException;
import java.nio.file.Path;

public class L2HImage
extends AbstractTeXObject
implements Expandable {
    private Path path;
    private String mimetype;
    private String name;
    private int width = 0;
    private int height = 0;
    private TeXObject alt;
    protected boolean useImgTag = false;

    public L2HImage(Path path) {
        this(path, null, 0, 0, null, null);
    }

    public L2HImage(Path path, String string) {
        this(path, string, 0, 0, null, null);
    }

    public L2HImage(Path path, String string, int n, int n2, String string2, TeXObject teXObject) {
        this(path, string, n, n2, string2, teXObject, false);
    }

    public L2HImage(Path path, String string, int n, int n2, String string2, TeXObject teXObject, boolean bl) {
        this.path = path;
        this.width = n;
        this.height = n2;
        this.alt = teXObject;
        this.useImgTag = bl;
        if (string == null) {
            this.updateMimeType();
        } else {
            this.mimetype = string;
        }
        if (string2 != null) {
            string2 = string2.replaceAll("[^\\w]", "");
        }
    }

    @Override
    public Object clone() {
        return new L2HImage(this.path, this.mimetype, this.width, this.height, this.name, this.alt == null ? null : (TeXObject)this.alt.clone());
    }

    protected void updateMimeType() {
        String string = this.path.getName(this.path.getNameCount() - 1).toString();
        int n = string.lastIndexOf(".");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(n).toLowerCase();
        }
        if (string2.equals("jpg") || string2.equals("jpeg")) {
            this.mimetype = "image/jpeg";
        } else if (string2.equals("png")) {
            this.mimetype = "image/png";
        } else if (string2.equals("pdf")) {
            this.mimetype = "application/pdf";
        }
    }

    public void setAlt(TeXObject teXObject) {
        this.alt = teXObject;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public String toString() {
        return String.format("%s[path=%s,width=%d,height=%d,type=%s,name=%s,alt=%s,useImgTag=%s]", this.getClass().getName(), this.path, this.width, this.height, this.mimetype, this.name, this.alt, this.useImgTag);
    }

    @Override
    public boolean isPar() {
        return false;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.alt.toString(teXParser);
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.alt.string(teXParser);
    }

    @Override
    public String format() {
        return this.alt == null ? "" : this.alt.format();
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        if (this.useImgTag && this.mimetype.startsWith("image")) {
            L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
            VoidElement voidElement = l2HConverter.createVoidElement("img");
            voidElement.putAttribute("src", HtmlTag.encodeAttributeValue(this.getData(), true));
            if (this.width != 0) {
                voidElement.putAttribute("width", "" + this.width);
            }
            if (this.height != 0) {
                voidElement.putAttribute("height", "" + this.height);
            }
            if (this.name != null) {
                voidElement.putAttribute("id", this.name);
            }
            if (this.alt != null) {
                voidElement.putAttribute("alt", HtmlTag.encodeAttributeValue(teXParser.expandToString(this.alt, teXObjectList), false));
            }
            teXObjectList2.add(voidElement);
        } else {
            StartElement startElement = new StartElement("object");
            startElement.putAttribute("data", HtmlTag.encodeAttributeValue(this.getData(), true));
            if (this.width != 0) {
                startElement.putAttribute("width", "" + this.width);
            }
            if (this.height != 0) {
                startElement.putAttribute("height", "" + this.height);
            }
            if (this.mimetype != null) {
                startElement.putAttribute("type", this.mimetype);
            }
            if (this.name != null) {
                startElement.putAttribute("id", this.name);
            }
            teXObjectList2.add(startElement);
            if (this.alt != null) {
                teXObjectList2.add(this.alt);
            }
            teXObjectList2.add(new EndElement("object"));
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        if (this.useImgTag && this.mimetype.startsWith("image")) {
            L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
            VoidElement voidElement = l2HConverter.createVoidElement("img");
            voidElement.putAttribute("src", HtmlTag.encodeAttributeValue(this.getData(), true));
            if (this.width != 0) {
                voidElement.putAttribute("width", "" + this.width);
            }
            if (this.height != 0) {
                voidElement.putAttribute("height", "" + this.height);
            }
            if (this.name != null) {
                voidElement.putAttribute("id", this.name);
            }
            if (this.alt != null) {
                voidElement.putAttribute("alt", HtmlTag.encodeAttributeValue(teXParser.expandToString(this.alt, teXObjectList), false));
            }
            teXObjectList2.add(voidElement);
        } else {
            StartElement startElement = new StartElement("object");
            startElement.putAttribute("data", HtmlTag.encodeAttributeValue(this.getData(), true));
            if (this.width != 0) {
                startElement.putAttribute("width", "" + this.width);
            }
            if (this.height != 0) {
                startElement.putAttribute("height", "" + this.height);
            }
            if (this.mimetype != null) {
                startElement.putAttribute("type", this.mimetype);
            }
            if (this.name != null) {
                startElement.putAttribute("id", this.name);
            }
            teXObjectList2.add(startElement);
            if (this.alt != null) {
                this.alt = TeXParserUtils.expandFully(this.alt, teXParser, teXObjectList);
                teXObjectList2.add(this.alt, true);
            }
            teXObjectList2.add(new EndElement("object"));
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public Path getPath() {
        return this.path;
    }

    private String getData() {
        int n = this.path.getNameCount();
        if (n == 1) {
            return this.path.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.path.getName(0).toString());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.path.getName(i).toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        l2HConverter.insertParIfRequired();
        if (this.useImgTag && this.mimetype.startsWith("image")) {
            l2HConverter.writeliteral(String.format("<img src=\"%s\"", HtmlTag.encodeAttributeValue(this.getData(), true)));
            if (this.width != 0) {
                l2HConverter.writeliteral(String.format(" width=\"%d\"", this.width));
            }
            if (this.height != 0) {
                l2HConverter.writeliteral(String.format(" height=\"%d\"", this.height));
            }
            if (this.name != null) {
                l2HConverter.writeliteral(String.format(" id=\"%s\"", this.name));
            }
            if (this.alt != null) {
                l2HConverter.writeliteral(" alt=\"");
                l2HConverter.writeliteral(HtmlTag.encodeAttributeValue(l2HConverter.processToString(this.alt, teXObjectList), false));
                l2HConverter.writeliteral("\"");
            }
            if (l2HConverter.isXml()) {
                l2HConverter.writeliteral("/");
            }
            l2HConverter.writeliteral(">");
        } else {
            l2HConverter.writeliteral(String.format("<object data=\"%s\"", HtmlTag.encodeAttributeValue(this.getData(), true)));
            if (this.width != 0) {
                l2HConverter.writeliteral(String.format(" width=\"%d\"", this.width));
            }
            if (this.height != 0) {
                l2HConverter.writeliteral(String.format(" height=\"%d\"", this.height));
            }
            if (this.mimetype != null) {
                l2HConverter.writeliteral(String.format(" type=\"%s\"", this.mimetype));
            }
            if (this.name != null) {
                l2HConverter.writeliteral(String.format(" id=\"%s\"", this.name));
            }
            l2HConverter.writeliteral(">");
            if (this.alt != null) {
                TeXParserUtils.process(this.alt, teXParser, teXObjectList);
            }
            l2HConverter.writeliteral("</object>");
        }
    }
}

