/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import java.io.IOException;

public class L2HTextSuperscript
extends ControlSequence {
    public static final int[][] UNICODE_SUPERSCRIPTS = new int[][]{{48, 8304}, {105, 8305}, {49, 185}, {50, 178}, {51, 179}, {52, 8308}, {53, 8309}, {54, 8310}, {55, 8311}, {56, 8312}, {57, 8313}, {43, 8314}, {45, 8315}, {8722, 8315}, {61, 8316}, {40, 8317}, {41, 8317}, {110, 8319}, {97, 170}, {111, 186}};

    public L2HTextSuperscript() {
        this("textsuperscript");
    }

    public L2HTextSuperscript(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HTextSuperscript(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        if (teXObject instanceof Expandable && (teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = teXObjectList2;
        }
        if (((L2HConverter)teXParser.getListener()).supportUnicodeScript() && this.hasUnicodeSupport(teXObject)) {
            teXObjectList.push(this.convert(teXParser, teXObject));
        } else {
            teXObjectList.push(new EndElement("sup"));
            teXObjectList.push(teXObject);
            teXObjectList.push(new StartElement("sup"));
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = teXParser.popNextArg();
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXObject = teXObjectList;
        }
        if (((L2HConverter)teXParser.getListener()).supportUnicodeScript() && this.hasUnicodeSupport(teXObject)) {
            teXParser.push(this.convert(teXParser, teXObject));
        } else {
            teXParser.push(new EndElement("sup"));
            teXParser.push(teXObject);
            teXParser.push(new StartElement("sup"));
        }
    }

    private TeXObject convert(TeXParser teXParser, TeXObject teXObject) {
        if (teXObject instanceof CharObject) {
            return this.getUnicode(teXParser, (CharObject)teXObject);
        }
        if (teXObject instanceof TeXNumber) {
            return this.convert(teXParser, teXParser.getListener().createString(teXObject.toString(teXParser)));
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        for (int i = 0; i < teXObjectList.size(); ++i) {
            teXObjectList.set(i, this.convert(teXParser, (TeXObject)teXObjectList.get(i)));
        }
        return teXObjectList;
    }

    private CharObject getUnicode(TeXParser teXParser, CharObject charObject) {
        int n = charObject.getCharCode();
        for (int i = 0; i < UNICODE_SUPERSCRIPTS.length; ++i) {
            if (UNICODE_SUPERSCRIPTS[i][0] != n) continue;
            return teXParser.getListener().getOther(UNICODE_SUPERSCRIPTS[i][1]);
        }
        throw new IllegalArgumentException("Unknown conversion to subscript: " + charObject);
    }

    private boolean hasUnicodeSupport(TeXObject teXObject) {
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof MathGroup)) {
            for (TeXObject teXObject2 : (TeXObjectList)teXObject) {
                if (this.hasUnicodeSupport(teXObject2)) continue;
                return false;
            }
            return true;
        }
        if (teXObject instanceof TeXNumber) {
            return true;
        }
        if (teXObject instanceof CharObject) {
            int n = ((CharObject)teXObject).getCharCode();
            for (int i = 0; i < UNICODE_SUPERSCRIPTS.length; ++i) {
                if (UNICODE_SUPERSCRIPTS[i][0] != n) continue;
                return true;
            }
        }
        return false;
    }
}

