/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.generic.PadNumber;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DTLgidxSetDefaultDB;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeaderRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolRows;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatagidxAtBothOfTwo;
import com.dickimawbooks.texparserlib.latex.datatool.DatagidxAtInvert;
import com.dickimawbooks.texparserlib.latex.datatool.DatagidxWordifyGreek;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.LoadGidx;
import com.dickimawbooks.texparserlib.latex.datatool.NewAcro;
import com.dickimawbooks.texparserlib.latex.datatool.NewGidx;
import com.dickimawbooks.texparserlib.latex.datatool.NewTerm;
import com.dickimawbooks.texparserlib.primitives.Unexpanded;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class DataGidxSty
extends LaTeXSty {
    protected DataToolSty datatoolSty;
    protected Vector<String> gidxDatabases;
    protected HashMap<String, DataBase> databaseMap;
    protected HashMap<String, String> labelToDatabase;
    protected HashMap<String, String> additionalKeyMap = new HashMap();
    public static final String ERROR_TERM_NOT_DEFINED = "datagidx.term_not_defined";
    public static final String ERROR_DATABASE_NOT_DEFINED = "datagidx.database_not_defined";
    public static final String ERROR_TERM_NO_DATABASES = "datagidx.no_databases";
    public static final String ERROR_NOT_INDEX_DATABASE = "datagidx.not_index_database";
    public static final String DEFAULT_DATABASE_NAME_TL = "l__datagidx_default_database_tl";
    public static final String HEADING_TL = "l__datagidx_heading_tl";
    public static final String POST_HEADING_TL = "l__datagidx_post_heading_tl";
    public static final String MULTICOLS_TL = "l__datagidx_multicols_tl";
    public static final String SORT_TL = "l__datagidx_sort_tl";
    public static final String STYLE_TL = "datagidx@style";
    public static final String SHOWGROUPS_TL = "datagidx@showgroups";

    public DataGidxSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "datagidx", laTeXParserListener, bl);
        this.additionalKeyMap.put("description", "Description");
        this.additionalKeyMap.put("symbol", "Symbol");
        this.additionalKeyMap.put("short", "Short");
        this.additionalKeyMap.put("shortplural", "ShortPlural");
        this.additionalKeyMap.put("long", "Long");
        this.additionalKeyMap.put("longplural", "LongPlural");
        this.additionalKeyMap.put("see", "See");
        this.additionalKeyMap.put("seealso", "SeeAlso");
    }

    @Override
    protected void preOptions(TeXObjectList teXObjectList) throws IOException {
        this.datatoolSty = (DataToolSty)this.getListener().requirepackage(null, "datatool", true, teXObjectList);
        this.datatoolSty.setDataGidxSty(this);
        this.datatoolSty.createDataBase("datagidx", true);
        this.datatoolSty.addNewColumn("datagidx", "Glossary");
        this.datatoolSty.addNewColumn("datagidx", "Title");
        this.datatoolSty.addNewColumn("datagidx", "Heading");
        this.datatoolSty.addNewColumn("datagidx", "PostHeading");
        this.datatoolSty.addNewColumn("datagidx", "MultiCols");
        this.datatoolSty.addNewColumn("datagidx", "Sort");
        this.datatoolSty.addNewColumn("datagidx", "Style");
        this.datatoolSty.addNewColumn("datagidx", "ShowGroups");
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new GenericCommand("newtermlabelhook"));
        this.registerControlSequence(new GenericCommand(DEFAULT_DATABASE_NAME_TL));
        this.registerControlSequence(new GenericCommand(POST_HEADING_TL));
        this.registerControlSequence(new TextualContentCommand(MULTICOLS_TL, "multicols"));
        this.registerControlSequence(new TextualContentCommand(STYLE_TL, "index"));
        this.registerControlSequence(new TextualContentCommand(SHOWGROUPS_TL, "false"));
        this.registerControlSequence(new DTLgidxSetDefaultDB());
        this.registerControlSequence(new NewGidx(this));
        this.registerControlSequence(new LoadGidx(this));
        this.registerControlSequence(new NewTerm(this));
        this.registerControlSequence(new NewAcro(this));
        TeXObjectList teXObjectList = this.getListener().createStack();
        if (this.getParser().getControlSequence("chapter") == null) {
            teXObjectList.add(new TeXCsRef("section"));
        } else {
            teXObjectList.add(new TeXCsRef("chapter"));
        }
        teXObjectList.add(this.getListener().getOther(42));
        this.registerControlSequence(new GenericCommand(true, HEADING_TL, null, teXObjectList));
        teXObjectList = this.getListener().createStack();
        teXObjectList.add(new TeXCsRef("DTLsortdata"));
        teXObjectList.add(this.getListener().getOther(91));
        teXObjectList.addAll(this.getListener().createString("save-group-key=LetterGroup"));
        teXObjectList.add(this.getListener().getOther(93));
        teXObjectList.add(TeXParserUtils.createGroup(this.getListener(), new TeXCsRef("DTLgidxCurrentdb")));
        Group group = this.getListener().createGroup();
        teXObjectList.add(group);
        group.addAll(this.getListener().createString("HierSort="));
        group.add(this.getListener().createGroup("replacements=Sort"));
        group.addAll(this.getListener().createString(",FirstId"));
        this.registerControlSequence(new GenericCommand(true, SORT_TL, null, teXObjectList));
        this.registerControlSequence(new AtFirstOfOne("__datagidx_punc:n"));
        this.registerControlSequence(new AtFirstOfOne("DTLgidxIgnore"));
        this.registerControlSequence(new AtGobble("DTLgidxGobble"));
        this.registerControlSequence(new AtFirstOfOne("DTLgidxNoFormat"));
        this.registerControlSequence(new AtFirstOfOne("DTLgidxMac"));
        this.registerControlSequence(new AtFirstOfOne("DTLgidxSaint"));
        this.registerControlSequence(new AtSecondOfTwo("DTLgidxPlace"));
        this.registerControlSequence(new AtSecondOfTwo("DTLgidxSubject"));
        this.registerControlSequence(new GenericCommand("newtermlabelhook"));
        this.registerControlSequence(new GenericCommand("newtermsorthook"));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLgidxStripBackslash", "m", TeXParserUtils.createStack(this.getListener(), new TeXCsRef("cs_to_str:N"), this.getListener().getParam(1))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLgidxName", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(1), new TeXCsRef("space"), this.getListener().getParam(2))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLgidxNameNum", "m", TeXParserUtils.createStack(this.getListener(), new TeXCsRef("@Roman"), TeXParserUtils.createGroup(this.getListener(), this.getListener().getParam(1)))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLgidxOffice", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(2), new TeXCsRef("space"), this.getListener().getOther(40), this.getListener().getParam(1), this.getListener().getOther(41))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLgidxRank", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(1), new TeXCsRef("nobreakspace"), this.getListener().getParam(2))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLgidxParticle", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(1), new TeXCsRef("nobreakspace"), this.getListener().getParam(2))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLgidxParen", "m", TeXParserUtils.createStack(this.getListener(), new TeXCsRef("space"), this.getListener().getOther(40), this.getListener().getParam(1), this.getListener().getOther(41))));
        this.registerControlSequence(new DatagidxWordifyGreek());
    }

    protected void addToCatalogue(TeXObjectList teXObjectList, KeyValList keyValList, String string, TeXObject teXObject) throws IOException {
        Object object;
        TeXObject teXObject2 = null;
        TeXObject teXObject3 = null;
        String string2 = null;
        String string3 = null;
        Boolean bl = null;
        TeXObject teXObject4 = null;
        if (keyValList != null) {
            teXObject4 = keyValList.getValue("sort");
            string3 = keyValList.getString("style", this.getParser(), teXObjectList);
            teXObject2 = keyValList.getValue("heading");
            teXObject3 = keyValList.getValue("post-heading");
            if (teXObject3 == null) {
                teXObject3 = keyValList.getValue("postheading");
            }
            if ((object = keyValList.getBoolean("balance", this.getParser(), teXObjectList)) != null) {
                String string4 = string2 = ((Boolean)object).booleanValue() ? "multicols" : "multicols*";
            }
            if ((bl = keyValList.getBoolean("show-groups", this.getParser(), teXObjectList)) == null) {
                bl = keyValList.getBoolean("showgroups", this.getParser(), teXObjectList);
            }
        }
        this.datatoolSty.addNewRow("datagidx");
        this.datatoolSty.addNewEntry("datagidx", "Glossary", this.getListener().createString(string));
        this.datatoolSty.addNewEntry("datagidx", "Title", teXObject);
        if (teXObject2 == null && (object = this.getParser().getControlSequence(HEADING_TL)) != null) {
            teXObject2 = TeXParserUtils.expandOnce((TeXObject)object, this.getParser(), teXObjectList);
        }
        if (teXObject2 != null) {
            this.datatoolSty.addNewEntry("datagidx", "Heading", teXObject2);
        }
        if (teXObject3 == null && (object = this.getParser().getControlSequence(POST_HEADING_TL)) != null) {
            teXObject3 = TeXParserUtils.expandOnce((TeXObject)object, this.getParser(), teXObjectList);
        }
        if (teXObject3 != null) {
            this.datatoolSty.addNewEntry("datagidx", "PostHeading", teXObject3);
        }
        if (string2 == null) {
            object = this.getParser().getControlSequence(MULTICOLS_TL);
            string2 = object == null ? "multicols" : this.getParser().expandToString((TeXObject)object, teXObjectList);
        }
        this.datatoolSty.addNewEntry("datagidx", "MultiCols", this.getListener().createString(string2));
        if (teXObject4 == null && (object = this.getParser().getControlSequence(SORT_TL)) != null) {
            teXObject4 = TeXParserUtils.expandOnce((TeXObject)object, this.getParser(), teXObjectList);
        }
        if (teXObject4 != null) {
            this.datatoolSty.addNewEntry("datagidx", "Sort", teXObject4);
        }
        if (string3 == null) {
            object = this.getParser().getControlSequence(STYLE_TL);
            string3 = object == null ? "index" : this.getParser().expandToString((TeXObject)object, teXObjectList);
        }
        this.datatoolSty.addNewEntry("datagidx", "Style", this.getListener().createString(string3));
        if (bl == null) {
            object = this.getParser().getControlSequence(SHOWGROUPS_TL);
            bl = object == null ? Boolean.FALSE : Boolean.valueOf(this.getParser().expandToString((TeXObject)object, teXObjectList));
        }
        this.datatoolSty.addNewEntry("datagidx", "ShowGroups", this.getListener().createString(bl.toString()));
    }

    public DataBase createDataBase(TeXObjectList teXObjectList, KeyValList keyValList, String string, TeXObject teXObject) throws IOException {
        this.addToCatalogue(teXObjectList, keyValList, string, teXObject);
        return this.createDataBase(string);
    }

    protected DataBase createDataBase(String string) throws IOException {
        DataBase dataBase = this.datatoolSty.createDataBase(string, true);
        DataToolHeader dataToolHeader = this.datatoolSty.addNewColumn(string, "Label");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Used");
        dataToolHeader.setType(DatumType.INTEGER);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Location");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "UnsafeLocation");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "CurrentLocation");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "FirstId");
        dataToolHeader.setType(DatumType.INTEGER);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Name");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Text");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Plural");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Parent");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Child");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Description");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "HierSort");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "LetterGroup");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Symbol");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Long");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "LongPlural");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "Short");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "ShortPlural");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "See");
        dataToolHeader.setType(DatumType.STRING);
        dataToolHeader = this.datatoolSty.addNewColumn(string, "SeeAlso");
        dataToolHeader.setType(DatumType.STRING);
        if (this.gidxDatabases == null) {
            this.gidxDatabases = new Vector();
        }
        this.gidxDatabases.add(string);
        if (this.databaseMap == null) {
            this.databaseMap = new HashMap();
        }
        this.databaseMap.put(string, dataBase);
        return dataBase;
    }

    public void addTerm(KeyValList keyValList, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        Object object;
        TeXObject teXObject2;
        Object object2;
        TeXParser teXParser = this.getParser();
        String string = null;
        String string2 = null;
        TeXObject teXObject3 = null;
        if (keyValList != null) {
            string2 = keyValList.getString("database", teXParser, teXObjectList);
            string = keyValList.getString("label", teXParser, teXObjectList);
            teXObject3 = keyValList.getValue("sort");
        }
        if (string2 == null) {
            object2 = teXParser.getControlSequence(DEFAULT_DATABASE_NAME_TL);
            if (object2 != null) {
                string2 = teXParser.expandToString((TeXObject)object2, teXObjectList);
            } else {
                string2 = this.getLatestIndexDataBaseName();
                if (string2 == null) {
                    throw new LaTeXSyntaxException(teXParser, ERROR_TERM_NO_DATABASES, new Object[0]);
                }
            }
        }
        if ((object2 = this.getIndexDataBase(string2)) == null) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DATABASE_NOT_DEFINED, string2);
        }
        if (string == null || teXObject3 == null) {
            teXParser.startGroup();
            teXParser.putControlSequence(new AtGobble("glsadd"));
            teXParser.putControlSequence(new AtFirstOfOne("MakeUppercase"));
            teXParser.putControlSequence(new AtFirstOfOne("MakeTextUppercase"));
            teXParser.putControlSequence(new AtFirstOfOne("MakeLowercase"));
            teXParser.putControlSequence(new AtFirstOfOne("MakeTextLowercase"));
            teXParser.putControlSequence(new AtFirstOfOne("acronymfont"));
            teXParser.putControlSequence(new AtFirstOfOne("textrm"));
            teXParser.putControlSequence(new AtFirstOfOne("texttt"));
            teXParser.putControlSequence(new AtFirstOfOne("textsf"));
            teXParser.putControlSequence(new AtFirstOfOne("textsc"));
            teXParser.putControlSequence(new AtFirstOfOne("textbf"));
            teXParser.putControlSequence(new AtFirstOfOne("textmd"));
            teXParser.putControlSequence(new AtFirstOfOne("textit"));
            teXParser.putControlSequence(new AtFirstOfOne("textsl"));
            teXParser.putControlSequence(new AtFirstOfOne("emph"));
            teXParser.putControlSequence(new AtFirstOfOne("textsuperscript"));
            teXParser.putControlSequence(new AtFirstOfOne("ensuremath"));
            TeXParserUtils.process(this.getListener().getControlSequence("datagidxwordifygreek"), teXParser, teXObjectList);
            if (string == null) {
                boolean bl;
                boolean bl2 = bl = teXObject3 != null;
                if (bl) {
                    teXParser.startGroup();
                }
                teXParser.putControlSequence(new AtGobble("DTLgidxParen"));
                teXParser.putControlSequence(new AtGobble("__datagidx_punc:n"));
                teXParser.putControlSequence(new AtSecondOfTwo("DTLgidxName"));
                teXParser.putControlSequence(new AtSecondOfTwo("DTLgidxOffice"));
                teXParser.putControlSequence(new AtFirstOfOne("DTLgidxIgnore"));
                teXParser.putControlSequence(new DatagidxAtInvert("DTLgidxPlace"));
                teXParser.putControlSequence(new DatagidxAtInvert("DTLgidxSubject"));
                teXParser.putControlSequence(new DatagidxAtBothOfTwo("DTLgidxParticle"));
                teXObject2 = this.getParser().getControlSequence("newtermlabelhook");
                if (teXObject2 != null && !((AbstractTeXObject)teXObject2).isEmpty()) {
                    TeXParserUtils.process(teXObject2, teXParser, teXObjectList);
                }
                string = teXParser.expandToString((TeXObject)teXObject.clone(), teXObjectList);
                string = string.replaceAll("[=\\-]", "");
                if (bl) {
                    teXParser.endGroup();
                }
            }
            if (teXObject3 == null) {
                teXParser.putControlSequence(new Unexpanded("__datagidx_punc:n"));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxName", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(2), new TeXCsRef("__datagidx_punc:n"), new TeXCsRef("datatoolpersoncomma"), this.getListener().getParam(1))));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxOffice", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(2), new TeXCsRef("__datagidx_punc:n"), new TeXCsRef("datatoolpersoncomma"), this.getListener().getParam(1))));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxPlace", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(2), new TeXCsRef("__datagidx_punc:n"), new TeXCsRef("datatoolplacecomma"), this.getListener().getParam(1))));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxSubject", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(2), new TeXCsRef("__datagidx_punc:n"), new TeXCsRef("datatoolsubjectcomma"), this.getListener().getParam(1))));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxParen", "m", TeXParserUtils.createStack(this.getListener(), new TeXCsRef("__datagidx_punc:n"), new TeXCsRef("datatoolparenstart"), this.getListener().getParam(1))));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxMac", "m", this.getListener().createString("Mac")));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxSaint", "m", this.getListener().createString("Saint")));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxRank", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(2), this.getListener().getOther(46))));
                teXParser.putControlSequence(new LaTeXGenericCommand(true, "DTLgidxParticle", "mm", TeXParserUtils.createStack(this.getListener(), this.getListener().getParam(2), this.getListener().getOther(46))));
                teXParser.putControlSequence(new PadNumber("DTLgidxNameNum", 2));
                teXParser.putControlSequence(new AtGobble("DTLgidxIgnore"));
                ControlSequence controlSequence = this.getParser().getControlSequence("newtermsorthook");
                if (controlSequence != null && !controlSequence.isEmpty()) {
                    TeXParserUtils.process(controlSequence, teXParser, teXObjectList);
                }
                teXObject3 = TeXParserUtils.expandFully((TeXObject)teXObject.clone(), this.getParser(), teXObjectList);
            }
            teXParser.endGroup();
        }
        this.datatoolSty.addNewRow(string2);
        if (this.labelToDatabase == null) {
            this.labelToDatabase = new HashMap();
        }
        this.labelToDatabase.put(string, string2);
        this.datatoolSty.addNewEntry(string2, "Label", this.getListener().createString(string));
        this.datatoolSty.addNewEntry(string2, "Name", teXObject);
        this.datatoolSty.addNewEntry(string2, "Sort", teXObject3);
        DataToolEntryRow dataToolEntryRow = null;
        teXObject2 = null;
        Object object3 = null;
        if (keyValList != null) {
            Object object4;
            TeXObject teXObject4;
            TeXObject teXObject5;
            Object object5;
            object = keyValList.getString("parent", teXParser, teXObjectList);
            if (object != null) {
                object5 = this.labelToDatabase.get(object);
                if (object5 == null) {
                    throw new LaTeXSyntaxException(this.getParser(), ERROR_TERM_NOT_DEFINED, object);
                }
                dataToolEntryRow = ((String)object5).equals(string2) ? this.getTerm((DataBase)object2, (String)object, teXObjectList) : this.getTerm((String)object5, (String)object, teXObjectList);
                this.datatoolSty.addNewEntry(string2, "Parent", this.getListener().createString((String)object));
                teXObject5 = ((DataBase)object2).getHeader("HierSort");
                int n = ((DataToolHeader)teXObject5).getColumnIndex();
                teXObject4 = dataToolEntryRow.getEntry(n);
                if (teXObject4 == null) {
                    teXObject5 = ((DataBase)object2).getHeader("Child");
                    n = ((DataToolHeader)teXObject5).getColumnIndex();
                    teXObject4 = dataToolEntryRow.getEntry(n);
                    if (teXObject4 == null) {
                        teXObject4 = new DataToolEntry(this.datatoolSty, n, this.getListener().createString(string));
                        dataToolEntryRow.add(teXObject4);
                    } else {
                        object4 = teXParser.expandToString(((DataToolEntry)teXObject4).getContents(), teXObjectList);
                        object4 = ((String)object4).isEmpty() ? string : (String)object4 + "," + string;
                        ((DataToolEntry)teXObject4).setContents(this.getListener().createString((String)object4));
                        teXObject4 = null;
                    }
                    teXObject5 = ((DataBase)object2).getHeader("Sort");
                    n = ((DataToolHeader)teXObject5).getColumnIndex();
                    teXObject4 = dataToolEntryRow.getEntry(n);
                }
                if (teXObject4 == null) {
                    object4 = (TeXObjectList)((DataToolEntry)teXObject4).getContents().clone();
                    TeXObjectList object6 = TeXParserUtils.toList((TeXObject)object4, teXParser);
                    object6.add(new TeXCsRef("datatoolctrlboundary"));
                    object6.add(new TeXCsRef("datatoolasciistart"));
                    object6.add((TeXObject)teXObject3.clone(), true);
                    this.datatoolSty.addNewEntry(string2, "HierSort", (TeXObject)object4);
                }
            }
            teXObject2 = keyValList.getValue("text");
            object3 = keyValList.getValue("plural");
            object5 = null;
            teXObject5 = null;
            TeXObject teXObject6 = null;
            teXObject4 = null;
            for (String string3 : this.additionalKeyMap.keySet()) {
                TeXObject teXObject7 = (TeXObject)keyValList.get(string3);
                if (teXObject7 == null) continue;
                if (string3.equals("short")) {
                    object5 = teXObject7;
                } else if (string3.equals("shortplural")) {
                    teXObject5 = teXObject7;
                } else if (string3.equals("long")) {
                    teXObject6 = teXObject7;
                } else if (string3.equals("longplural")) {
                    teXObject4 = teXObject7;
                }
                this.datatoolSty.addNewEntry(string2, this.additionalKeyMap.get(string3), teXObject7);
            }
            if (object5 != null && teXObject5 == null) {
                teXObject5 = (TeXObject)object5.clone();
                object4 = TeXParserUtils.toList(teXObject5, teXParser);
                ((TeXObjectList)object4).add(this.getListener().getLetter(115));
                this.datatoolSty.addNewEntry(string2, "ShortPlural", (TeXObject)object4);
            }
            if (teXObject6 != null && teXObject4 == null) {
                teXObject4 = (TeXObject)teXObject6.clone();
                object4 = TeXParserUtils.toList(teXObject4, teXParser);
                ((TeXObjectList)object4).add(this.getListener().getLetter(115));
                this.datatoolSty.addNewEntry(string2, "LongPlural", (TeXObject)object4);
            }
        }
        if (teXObject2 == null) {
            teXObject2 = (TeXObject)teXObject.clone();
        }
        if (object3 == null) {
            object3 = (TeXObject)teXObject.clone();
            object = TeXParserUtils.toList((TeXObject)object3, teXParser);
            ((TeXObjectList)object).add(this.getListener().getOther(115));
            object3 = object;
        }
        this.datatoolSty.addNewEntry(string2, "Text", teXObject2);
        this.datatoolSty.addNewEntry(string2, "Plural", (TeXObject)object3);
        this.datatoolSty.addNewEntry(string2, "Used", UserNumber.ZERO);
    }

    public DataToolEntryRow getTerm(String string, String string2, TeXObjectList teXObjectList) throws IOException {
        DataBase dataBase = this.getIndexDataBase(string);
        if (dataBase == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_DATABASE_NOT_DEFINED, string);
        }
        return this.getTerm(dataBase, string2, teXObjectList);
    }

    public DataToolEntryRow getTerm(DataBase dataBase, String string, TeXObjectList teXObjectList) throws IOException {
        TeXParser teXParser = this.getParser();
        DataToolHeader dataToolHeader = dataBase.getHeader("Label");
        int n = dataToolHeader.getColumnIndex();
        DataToolRows dataToolRows = dataBase.getData();
        DataToolEntryRow dataToolEntryRow = null;
        for (DataToolEntryRow dataToolEntryRow2 : dataToolRows) {
            TeXObject teXObject;
            String string2;
            DataToolEntry dataToolEntry = dataToolEntryRow2.getEntry(n);
            if (dataToolEntry == null || !(string2 = teXParser.expandToString((TeXObject)(teXObject = dataToolEntry.getContents()).clone(), teXObjectList)).equals(string)) continue;
            dataToolEntryRow = dataToolEntryRow2;
            break;
        }
        if (dataToolEntryRow == null) {
            throw new LaTeXSyntaxException(teXParser, ERROR_TERM_NOT_DEFINED, string);
        }
        return dataToolEntryRow;
    }

    public void indexDataBaseLoaded(String string, KeyValList keyValList, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        TeXParser teXParser = this.getParser();
        TeXApp teXApp = this.getListener().getTeXApp();
        DataBase dataBase = this.datatoolSty.getDataBase(string);
        if (dataBase == null) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DATABASE_NOT_DEFINED, string);
        }
        DataToolHeaderRow dataToolHeaderRow = dataBase.getHeaders();
        DataToolRows dataToolRows = dataBase.getData();
        DataToolHeader dataToolHeader = dataToolHeaderRow.getHeader("Label");
        if (dataToolHeader == null) {
            teXApp.warning(teXParser, teXApp.getMessage(ERROR_NOT_INDEX_DATABASE, string));
            return;
        }
        int n = dataToolHeader.getColumnIndex();
        if (this.gidxDatabases == null) {
            this.gidxDatabases = new Vector();
        }
        this.gidxDatabases.add(string);
        if (this.databaseMap == null) {
            this.databaseMap = new HashMap();
        }
        this.databaseMap.put(string, dataBase);
        if (this.labelToDatabase == null) {
            this.labelToDatabase = new HashMap();
        }
        for (DataToolEntryRow dataToolEntryRow : dataToolRows) {
            DataToolEntry dataToolEntry = dataToolEntryRow.getEntry(n);
            if (dataToolEntry == null) continue;
            String string2 = teXParser.expandToString((TeXObject)dataToolEntry.getContents().clone(), teXObjectList);
            this.labelToDatabase.put(string2, string);
        }
        if (dataToolHeaderRow.getHeader("HierSort") == null) {
            dataToolHeader = this.datatoolSty.addNewColumn(string, "HierSort");
            dataToolHeader.setType(DatumType.STRING);
        }
        if (dataToolHeaderRow.getHeader("LetterGroup") == null) {
            dataToolHeader = this.datatoolSty.addNewColumn(string, "LetterGroup");
            dataToolHeader.setType(DatumType.STRING);
        }
        if (dataToolHeaderRow.getHeader("UnsafeLocation") == null) {
            dataToolHeader = this.datatoolSty.addNewColumn(string, "UnsafeLocation");
            dataToolHeader.setType(DatumType.STRING);
        }
        this.addToCatalogue(teXObjectList, keyValList, string, teXObject);
    }

    public DataToolSty getDataToolSty() {
        return this.datatoolSty;
    }

    public int getIndexDataBaseCount() {
        return this.gidxDatabases == null ? 0 : this.gidxDatabases.size();
    }

    public String getLatestIndexDataBaseName() {
        return this.getIndexDataBaseCount() == 0 ? null : this.gidxDatabases.lastElement();
    }

    public DataBase getIndexDataBase(String string) {
        return this.databaseMap == null ? null : this.databaseMap.get(string);
    }
}

