/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.mhchem;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.SbChar;
import com.dickimawbooks.texparserlib.SpChar;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import java.io.IOException;

public class Ce
extends ControlSequence {
    private static final int SEP = 8287;
    private static final String[][] KNOWN_COMMANDS = new String[][]{{"alpha", "\u03b1"}, {"beta", "\u03b2"}, {"gamma", "\u03b3"}, {"delta", "\u03b4"}, {"varepsilon", "\u03b5"}, {"zeta", "\u03b6"}, {"eta", "\u03b7"}, {"theta", "\u03b8"}, {"iota", "\u03b9"}, {"kappa", "\u03ba"}, {"lambda", "\u03bb"}, {"mu", "\u03bc"}, {"nu", "\u03bd"}, {"xi", "\u03be"}, {"omicron", "\u03bf"}, {"pi", "\u03c0"}, {"rho", "\u03c1"}, {"varsigma", "\u03c2"}, {"sigma", "\u03c3"}, {"tau", "\u03c4"}, {"upsilon", "\u03c5"}, {"phi", "\u03c6"}, {"chi", "\u03c7"}, {"psi", "\u03c8"}, {"omega", "\u03c9"}, {"epsilon", "\u03f5"}, {"Alpha", "\u0391"}, {"Beta", "\u0392"}, {"Gamma", "\u0393"}, {"Delta", "\u0394"}, {"Epsilon", "\u0395"}, {"Zeta", "\u0396"}, {"Eta", "\u0397"}, {"Theta", "\u0398"}, {"Iota", "\u0399"}, {"Kappa", "\u039a"}, {"Lambda", "\u039b"}, {"Mu", "\u039c"}, {"Nu", "\u039d"}, {"Xi", "\u039e"}, {"Omicron", "\u039f"}, {"Pi", "\u03a0"}, {"Rho", "\u03a1"}, {"Sigma", "\u03a3"}, {"Tau", "\u03a4"}, {"Upsilon", "\u03a5"}, {"Phi", "\u03a6"}, {"Chi", "\u03a7"}, {"Psi", "\u03a8"}, {"Omega", "\u03a9"}};
    private static final String[][] KNOWN_MATH_COMMANDS = new String[][]{{"alpha", new String(new int[]{120572}, 0, 1)}, {"beta", new String(new int[]{120573}, 0, 1)}, {"gamma", new String(new int[]{120574}, 0, 1)}, {"delta", new String(new int[]{120575}, 0, 1)}, {"varepsilon", new String(new int[]{120576}, 0, 1)}, {"zeta", new String(new int[]{120577}, 0, 1)}, {"eta", new String(new int[]{120578}, 0, 1)}, {"theta", new String(new int[]{120579}, 0, 1)}, {"iota", new String(new int[]{120580}, 0, 1)}, {"kappa", new String(new int[]{120581}, 0, 1)}, {"lambda", new String(new int[]{120582}, 0, 1)}, {"mu", new String(new int[]{120583}, 0, 1)}, {"nu", new String(new int[]{120584}, 0, 1)}, {"xi", new String(new int[]{120585}, 0, 1)}, {"omicron", new String(new int[]{120586}, 0, 1)}, {"pi", new String(new int[]{120587}, 0, 1)}, {"rho", new String(new int[]{120588}, 0, 1)}, {"varsigma", new String(new int[]{120589}, 0, 1)}, {"sigma", new String(new int[]{120590}, 0, 1)}, {"tau", new String(new int[]{120591}, 0, 1)}, {"upsilon", new String(new int[]{120592}, 0, 1)}, {"varphi", new String(new int[]{120593}, 0, 1)}, {"chi", new String(new int[]{120594}, 0, 1)}, {"psi", new String(new int[]{120595}, 0, 1)}, {"omega", new String(new int[]{120596}, 0, 1)}, {"epsilon", new String(new int[]{120598}, 0, 1)}, {"vartheta", new String(new int[]{120599}, 0, 1)}, {"varkappa", new String(new int[]{120600}, 0, 1)}, {"phi", new String(new int[]{120601}, 0, 1)}, {"varrho", new String(new int[]{120602}, 0, 1)}, {"varpi", new String(new int[]{120603}, 0, 1)}, {"Alpha", new String(new int[]{120546}, 0, 1)}, {"Beta", new String(new int[]{120547}, 0, 1)}, {"Gamma", new String(new int[]{120548}, 0, 1)}, {"Delta", new String(new int[]{120549}, 0, 1)}, {"Epsilon", new String(new int[]{120550}, 0, 1)}, {"Zeta", new String(new int[]{120551}, 0, 1)}, {"Eta", new String(new int[]{120552}, 0, 1)}, {"Theta", new String(new int[]{120553}, 0, 1)}, {"Iota", new String(new int[]{120554}, 0, 1)}, {"Kappa", new String(new int[]{120555}, 0, 1)}, {"Lambda", new String(new int[]{120556}, 0, 1)}, {"Mu", new String(new int[]{120557}, 0, 1)}, {"Nu", new String(new int[]{120558}, 0, 1)}, {"Xi", new String(new int[]{120559}, 0, 1)}, {"Omicron", new String(new int[]{120560}, 0, 1)}, {"Pi", new String(new int[]{120561}, 0, 1)}, {"Rho", new String(new int[]{120562}, 0, 1)}, {"Theta", new String(new int[]{120563}, 0, 1)}, {"Sigma", new String(new int[]{120564}, 0, 1)}, {"Tau", new String(new int[]{120565}, 0, 1)}, {"Upsilon", new String(new int[]{120566}, 0, 1)}, {"Phi", new String(new int[]{120567}, 0, 1)}, {"Chi", new String(new int[]{120568}, 0, 1)}, {"Psi", new String(new int[]{120569}, 0, 1)}, {"Omega", new String(new int[]{120570}, 0, 1)}, {"nabla", new String(new int[]{120571}, 0, 1)}, {"infty", "\u221e"}};

    public Ce() {
        this("ce");
    }

    public Ce(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new Ce(this.getName());
    }

    private void popScript(TeXParser teXParser, TeXObjectList teXObjectList, Group group) throws IOException {
        while (teXObjectList.size() > 0) {
            TeXObject teXObject = teXObjectList.popStack(teXParser);
            if (!(teXObject instanceof CharObject)) {
                teXObjectList.push(teXObject);
                return;
            }
            int n = ((CharObject)teXObject).getCharCode();
            if (Character.isDigit(n) || n == 43 || n == 45) {
                group.add(teXObject);
                continue;
            }
            teXObjectList.push(teXObject);
            break;
        }
    }

    private boolean isNumeric(TeXObject teXObject) {
        int n;
        if (teXObject instanceof Numerical || teXObject instanceof CharObject && Character.isDigit(((CharObject)teXObject).getCharCode())) {
            return true;
        }
        if (!(teXObject instanceof TeXObjectList)) {
            return false;
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        int n2 = teXObjectList.size();
        if (n2 == 0) {
            return false;
        }
        TeXObject teXObject2 = (TeXObject)teXObjectList.get(0);
        if (teXObject2 instanceof CharObject ? (n = ((CharObject)teXObject2).getCharCode()) != 43 && n != 45 && !Character.isDigit(n) : !this.isNumeric(teXObject2)) {
            return false;
        }
        for (n = 1; n < n2; ++n) {
            if (this.isNumeric((TeXObject)teXObjectList.get(n))) continue;
            return false;
        }
        return true;
    }

    private void pushFraction(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        try {
            int n = teXObject instanceof Numerical ? ((Numerical)teXObject).number(teXParser) : (teXObject instanceof Group ? Integer.parseInt(((Group)teXObject).toList().toString(teXParser)) : Integer.parseInt(teXObject.toString(teXParser)));
            int n2 = teXObject2 instanceof Numerical ? ((Numerical)teXObject2).number(teXParser) : (teXObject2 instanceof Group ? Integer.parseInt(((Group)teXObject2).toList().toString(teXParser)) : Integer.parseInt(teXObject2.toString(teXParser)));
            if (n == 1 && n2 == 2) {
                teXObjectList.push(teXParser.getListener().getOther(189));
            } else if (n == 1 && n2 == 4) {
                teXObjectList.push(teXParser.getListener().getOther(188));
            } else if (n == 3 && n2 == 4) {
                teXObjectList.push(teXParser.getListener().getOther(190));
            } else if (n == 1 && n2 == 7) {
                teXObjectList.push(teXParser.getListener().getOther(8528));
            } else if (n == 1 && n2 == 9) {
                teXObjectList.push(teXParser.getListener().getOther(8529));
            } else if (n == 1 && n2 == 10) {
                teXObjectList.push(teXParser.getListener().getOther(8530));
            } else if (n == 1 && n2 == 3) {
                teXObjectList.push(teXParser.getListener().getOther(8531));
            } else if (n == 2 && n2 == 3) {
                teXObjectList.push(teXParser.getListener().getOther(8532));
            } else if (n == 1 && n2 == 5) {
                teXObjectList.push(teXParser.getListener().getOther(8533));
            } else if (n == 2 && n2 == 5) {
                teXObjectList.push(teXParser.getListener().getOther(8534));
            } else if (n == 3 && n2 == 5) {
                teXObjectList.push(teXParser.getListener().getOther(8535));
            } else if (n == 4 && n2 == 5) {
                teXObjectList.push(teXParser.getListener().getOther(8536));
            } else if (n == 1 && n2 == 6) {
                teXObjectList.push(teXParser.getListener().getOther(8537));
            } else if (n == 5 && n2 == 6) {
                teXObjectList.push(teXParser.getListener().getOther(8538));
            } else if (n == 1 && n2 == 8) {
                teXObjectList.push(teXParser.getListener().getOther(8539));
            } else if (n == 3 && n2 == 8) {
                teXObjectList.push(teXParser.getListener().getOther(8540));
            } else if (n == 5 && n2 == 8) {
                teXObjectList.push(teXParser.getListener().getOther(8541));
            } else if (n == 7 && n2 == 8) {
                teXObjectList.push(teXParser.getListener().getOther(8542));
            } else if (n == 0 && n2 == 3) {
                teXObjectList.push(teXParser.getListener().getOther(8585));
            } else {
                teXObjectList.push(teXParser.getListener().getOther(40));
                teXObjectList.push(teXObject);
                teXObjectList.push(teXParser.getListener().getOther(47));
                teXObjectList.push(teXObject2);
                teXObjectList.push(teXParser.getListener().getOther(41));
            }
        }
        catch (NumberFormatException numberFormatException) {
            teXObjectList.push(teXObject);
            teXObjectList.push(teXParser.getListener().getOther(47));
            teXObjectList.push(teXObject2);
        }
    }

    private TeXObject processMathGroup(TeXParser teXParser, MathGroup mathGroup) {
        TeXObjectList teXObjectList = new TeXObjectList();
        for (TeXObject teXObject : mathGroup) {
            if (teXObject instanceof ControlSequence) {
                String string = this.getMathSymbol((ControlSequence)teXObject);
                if (teXObject == null) {
                    return mathGroup;
                }
                teXObjectList.add(teXParser.getListener().createString(string));
                continue;
            }
            if (!(teXObject instanceof CharObject)) {
                return mathGroup;
            }
            int n = ((CharObject)teXObject).getCharCode();
            if (n == 104) {
                teXObjectList.add(teXParser.getListener().getOther(8462));
                continue;
            }
            if (n >= 97 && n <= 122) {
                teXObjectList.add(teXParser.getListener().getOther(n - 97 + 119886));
                continue;
            }
            if (n >= 65 && n <= 90) {
                teXObjectList.add(teXParser.getListener().getOther(n - 65 + 119860));
                continue;
            }
            return mathGroup;
        }
        return teXObjectList;
    }

    private String getSymbol(ControlSequence controlSequence) {
        String string = controlSequence.getName();
        for (int i = 0; i < KNOWN_COMMANDS.length; ++i) {
            if (!string.equals(KNOWN_COMMANDS[i][0])) continue;
            return KNOWN_COMMANDS[i][1];
        }
        return null;
    }

    private String getMathSymbol(ControlSequence controlSequence) {
        String string = controlSequence.getName();
        for (int i = 0; i < KNOWN_MATH_COMMANDS.length; ++i) {
            if (!string.equals(KNOWN_MATH_COMMANDS[i][0])) continue;
            return KNOWN_MATH_COMMANDS[i][1];
        }
        return null;
    }

    protected TeXObject processArg(TeXParser teXParser, TeXObject teXObject) throws IOException {
        if (!(teXObject instanceof TeXObjectList)) {
            return teXObject;
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        TeXObjectList teXObjectList2 = new TeXObjectList();
        boolean bl = true;
        while (teXObjectList.size() > 0) {
            TeXObject teXObject2 = teXObjectList.popStack(teXParser);
            if (teXObject2 instanceof WhiteSpace) {
                bl = true;
                teXObjectList2.add(teXParser.getListener().getOther(8287));
                continue;
            }
            if (teXObject2 instanceof CharObject) {
                TeXObject teXObject3;
                int n = ((CharObject)teXObject2).getCharCode();
                if (bl) {
                    if (n == 45) {
                        teXObject3 = (TeXObject)teXObjectList.firstElement();
                        if (teXObject3 != null && teXObject3 instanceof CharObject && ((CharObject)teXObject3).getCharCode() == 62) {
                            teXObject3 = teXObjectList.popStack(teXParser);
                            teXObjectList2.add(teXParser.getListener().getOther(10230));
                            TeXObject teXObject4 = null;
                            if (!(teXObjectList.firstElement() instanceof WhiteSpace)) {
                                teXObject4 = teXObjectList.popArg(teXParser, 91, 93);
                            }
                            if (teXObject4 != null) {
                                teXObjectList2.add(new TeXCsRef("textsuperscript"));
                                if (teXObject4 instanceof Group) {
                                    teXObjectList2.add(teXObject4);
                                } else if (teXObject4 instanceof TeXObjectList) {
                                    Group group = teXParser.getListener().createGroup();
                                    teXObjectList2.add(group);
                                    group.addAll((TeXObjectList)teXObject4);
                                } else {
                                    teXObjectList2.add(teXObject4);
                                }
                            }
                        } else {
                            teXObjectList2.add(teXObject2);
                        }
                    } else if (Character.isDigit(n)) {
                        teXObjectList.push(teXObject2);
                        teXObject2 = teXObjectList.popNumber(teXParser);
                        teXObjectList2.add(teXObject2);
                    } else {
                        teXObjectList2.add(teXObject2);
                    }
                } else if (n == 47) {
                    teXObject3 = (TeXObject)teXObjectList.firstElement();
                    if (teXObject3 != null && this.isNumeric(teXObject3) && teXObjectList2.lastElement() != null) {
                        teXObject3 = teXObjectList.popNumber(teXParser);
                        this.pushFraction(teXParser, teXObjectList2, (TeXObject)teXObjectList2.remove(teXObjectList2.size() - 1), teXObject3);
                    } else {
                        teXObjectList2.add(teXObject3);
                    }
                } else if (n == 43 || n == 45 || Character.isDigit(n)) {
                    teXObjectList2.add(new TeXCsRef("textsubscript"));
                    teXObject3 = teXParser.getListener().createGroup();
                    teXObjectList2.add(teXObject3);
                    ((TeXObjectList)teXObject3).add(teXObject2);
                    this.popScript(teXParser, teXObjectList, (Group)teXObject3);
                } else {
                    teXObjectList2.add(teXObject2);
                }
            } else if (teXObject2 instanceof SpChar) {
                teXObjectList2.add(new TeXCsRef("textsuperscript"));
                teXObject2 = teXObjectList.popStack(teXParser);
                if (!(teXObject2 instanceof CharObject)) {
                    teXObjectList2.add(teXObject2);
                } else {
                    Group group = teXParser.getListener().createGroup();
                    teXObjectList2.add(group);
                    group.add(teXObject2);
                    this.popScript(teXParser, teXObjectList, group);
                }
            } else if (teXObject2 instanceof SbChar) {
                teXObjectList2.add(new TeXCsRef("textsubscript"));
                teXObject2 = teXObjectList.popStack(teXParser);
                if (!(teXObject2 instanceof CharObject)) {
                    teXObjectList2.add(teXObject2);
                } else {
                    Group group = teXParser.getListener().createGroup();
                    teXObjectList2.add(group);
                    group.add(teXObject2);
                    this.popScript(teXParser, teXObjectList, group);
                }
            } else if (teXObject2 instanceof ControlSequence) {
                String string = this.getSymbol((ControlSequence)teXObject2);
                if (string == null) {
                    teXObjectList2.add(teXObject2);
                } else {
                    teXObjectList2.add(teXParser.getListener().createString(string));
                }
            } else if (teXObject2 instanceof MathGroup) {
                teXObjectList2.add(this.processMathGroup(teXParser, (MathGroup)teXObject2));
            } else {
                teXObjectList2.add(teXObject2);
            }
            bl = false;
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        this.processArg(teXParser, teXObject).process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        this.processArg(teXParser, teXObject).process(teXParser, teXObjectList);
    }
}

