/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXFontWeight;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.primitives.TeXFontDeclaration;
import java.io.IOException;

public class TeXFontFamilyDeclaration
extends TeXFontDeclaration {
    private TeXFontFamily family;
    private TeXFontFamily orgFamily;
    private TeXFontWeight orgWeight;
    private TeXFontShape orgShape;

    public TeXFontFamilyDeclaration(String string, int n) {
        super(string);
        this.orgWeight = TeXFontWeight.INHERIT;
        this.orgFamily = TeXFontFamily.INHERIT;
        this.orgShape = TeXFontShape.INHERIT;
        switch (n) {
            case -1: {
                this.family = TeXFontFamily.INHERIT;
                break;
            }
            case 0: {
                this.family = TeXFontFamily.RM;
                break;
            }
            case 1: {
                this.family = TeXFontFamily.SF;
                break;
            }
            case 3: {
                this.family = TeXFontFamily.CAL;
                break;
            }
            case 2: {
                this.family = TeXFontFamily.TT;
                break;
            }
            case 4: {
                this.family = TeXFontFamily.VERB;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid font name ID " + n);
            }
        }
    }

    public TeXFontFamilyDeclaration(String string, TeXFontFamily teXFontFamily) {
        super(string);
        this.family = teXFontFamily;
        this.orgWeight = TeXFontWeight.INHERIT;
        this.orgFamily = TeXFontFamily.INHERIT;
        this.orgShape = TeXFontShape.INHERIT;
    }

    @Override
    public Object clone() {
        return new TeXFontFamilyDeclaration(this.getName(), this.family);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgWeight = teXSettings.getCurrentFontWeight();
        this.orgShape = teXSettings.getCurrentFontShape();
        this.orgFamily = teXSettings.getCurrentFontFamily();
        teXSettings.setFontWeight(TeXFontWeight.MD);
        teXSettings.setFontShape(TeXFontShape.UP);
        teXSettings.setFontFamily(this.family);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontWeight(this.orgWeight);
        teXSettings.setFontShape(this.orgShape);
        teXSettings.setFontFamily(this.orgFamily);
    }
}

