/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Field;
import org.mvel2.OptimizationFailure;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.VariableResolverFactory;

public class StaticVarAccessorNH
implements AccessorNode {
    private AccessorNode nextNode;
    Field field;
    private PropertyHandler nullHandler;

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            Object v = this.field.get(ctx);
            if (v == null) {
                v = this.nullHandler.getProperty(this.field.getName(), elCtx, vars);
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(v, elCtx, vars);
            }
            return v;
        }
        catch (Exception e) {
            throw new OptimizationFailure("unable to access static field", e);
        }
    }

    public StaticVarAccessorNH(Field field, PropertyHandler handler2) {
        this.field = field;
        this.nullHandler = handler2;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(this.field.get(null), elCtx, variableFactory, value);
            }
            this.field.set(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException("error accessing static variable", e);
        }
        return value;
    }

    @Override
    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

