//
// Copyright 2017 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
#ifndef PXR_BASE_VT_API_H
#define PXR_BASE_VT_API_H

#include "pxr/base/arch/export.h"

#if defined(PXR_STATIC)
#   define VT_API
#   define VT_API_TEMPLATE_CLASS(...)
#   define VT_API_TEMPLATE_STRUCT(...)
#   define VT_LOCAL
#else
#   if defined(VT_EXPORTS)
#       define VT_API ARCH_EXPORT
#       define VT_API_TEMPLATE_CLASS(...) ARCH_EXPORT_TEMPLATE(class, __VA_ARGS__)
#       define VT_API_TEMPLATE_STRUCT(...) ARCH_EXPORT_TEMPLATE(struct, __VA_ARGS__)
#   else
#       define VT_API ARCH_IMPORT
#       define VT_API_TEMPLATE_CLASS(...) ARCH_IMPORT_TEMPLATE(class, __VA_ARGS__)
#       define VT_API_TEMPLATE_STRUCT(...) ARCH_IMPORT_TEMPLATE(struct, __VA_ARGS__)
#   endif
#   define VT_LOCAL ARCH_HIDDEN
#endif

#endif
