// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeUnsignedCharArray
 * @brief   composite implicit array of unsigned char.
 *
 * vtkCompositeUnsignedCharArray is a composite implicit array of values of type unsigned char.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkCompositeUnsignedCharArray_h
#define vtkCompositeUnsignedCharArray_h

#include "vtkCompositeArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<unsigned char>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT vtkCompositeUnsignedCharArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeUnsignedCharArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeUnsignedCharArray* New();
  static vtkCompositeUnsignedCharArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned char);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeUnsignedCharArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeUnsignedCharArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeUnsignedCharArray();
  ~vtkCompositeUnsignedCharArray() override;

private:
  typedef vtkCompositeArray<unsigned char> RealSuperclass;

  vtkCompositeUnsignedCharArray(const vtkCompositeUnsignedCharArray&) = delete;
  void operator=(const vtkCompositeUnsignedCharArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeUnsignedCharArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
